{% from "components/postgres/pg.jinja" import pg with context %}

{% set dbname = 'maildb' %}
{% set target = salt['pillar.get']('data:maildb:target', 'latest') %}
{% set path = salt['pillar.get']('data:dbfiles_path', '/usr/local/yandex/') %}

{# Remember that the order is important! #}
{%
    set sqls = [
        'common/is_master.sql',
        'common/check_partitions.sql'
    ]
%}

/usr/local/yandex/sqls/sharpei_fdw.sql:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/sharpei_fdw.sql
        - user: postgres
        - group: postgres
        - mode: 700
        - require:
            - service: postgresql-service

{% for sql in sqls %}
{{ dbname + path + sql }}:
    file.managed:
        - source: salt://components/pg-code/{{ sql }}
        - name: {{ path + sql }}
        - user: postgres
        - template: jinja
        - mode: 744
        - makedirs: True
        - require:
            - cmd: postgresql-service
{% endfor %}

{{ path + dbname }}:
    file.recurse:
        - source: salt://components/pg-code/{{ dbname }}
        - user: postgres
        - template: jinja
        - dir_mode: 755
        - file_mode: 744
        - makedirs: True
        - clean: True
        - exclude_pat: 'E@(.git)|(ora2pg)|(tests)|(pymdb)|(pg_cleanup)|(jenkins)|(docker)|(husky)|(integration)'
        - require:
            - service: postgresql-service
        - defaults:
            default_dbname: {{ dbname }}

{% if salt['grains.get']('pg') and 'role' in salt['grains.get']('pg').keys() and salt['grains.get']('pg')['role'] == 'master' %}

create_db_{{ dbname }}:
    postgres_database.present:
        - name: {{ dbname }}
        - user: postgres
        - require:
            - cmd: postgresql-service

create_repl_mon_fdw_{{ dbname }}:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/repl_mon.sql
        - maintenance_db: {{ dbname }}
        - require:
            - postgres_database: create_db_{{ dbname }}
            - file: /usr/local/yandex/sqls/repl_mon.sql
        - unless:
            - -c "SELECT c.relname FROM pg_catalog.pg_foreign_table ft INNER JOIN pg_catalog.pg_class c ON c.oid = ft.ftrelid;" | grep repl_mon

create_sharpei_fdw_{{ dbname }}:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/sharpei_fdw.sql
        - maintenance_db: {{ dbname }}
        - require:
            - postgres_database: create_db_{{ dbname }}
            - file: /usr/local/yandex/sqls/sharpei_fdw.sql
        - unless:
            - -c "SELECT c.relname FROM pg_catalog.pg_foreign_table ft INNER JOIN pg_catalog.pg_class c ON c.oid = ft.ftrelid;" | grep sharpei_users

{{ dbname + '-schemas-apply' }}:
    postgresql_schema.applied:
        - name: {{ dbname }}
        - target: {{ target }}
        - termination_interval: 0.1
        - conn: 'dbname={{ dbname }}\ user=postgres\ connect_timeout=1'
        - callbacks:
            beforeAll:
                - {{ path + dbname }}/constants
            afterAll:
                - {{ path + dbname }}/drops
                - {{ path + dbname }}/impl
                - {{ path + dbname }}/code
{% for sql in sqls %}
                - {{ path + sql }}
{% endfor %}
                - {{ path + dbname }}/util
                - {{ path + dbname }}/grants
        - require:
            - postgres_database: create_db_{{ dbname }}
{% if salt['grains.get']('os') != 'Ubuntu' %}
            - pkg: pgxxhash{{ pg.version.short }}
{% endif %}
            - pkg: yamail-pgmigrate
            - postgres_user: postgres-user-furita
            - file: {{ path + dbname }}
{% for sql in sqls %}
            - file: {{ path + sql }}
{% endfor %}

{% endif %}
