#!/usr/bin/env python

import psycopg2
import sys
import argparse

parser = argparse.ArgumentParser()

parser.add_argument('-d', '--database', type=str,
                    default='maildb', help='Database to connect')

parser.add_argument('-s', '--schema', type=str,
                    default='mail', help='Name of the schema')

parser.add_argument('-t', '--table', type=str,
                    default='change_log', help='Name of the table')

parser.add_argument('-f', '--field', type=str,
                    default='cid', help='Field for adding constraint')

args = parser.parse_args()

def main():
    conn = psycopg2.connect('dbname=%s connect_timeout=1' % args.database)
    cur = conn.cursor()

    cur.execute("show transaction_read_only;")

    if 'on' in str(cur.fetchone()[0]):
        sys.exit(0)

    cur.execute("SET lock_timeout TO 0;")

    cur.execute("SELECT datetime_string FROM partman.part_config "
                "WHERE parent_table = '%s.%s';" % (args.schema, args.table))
    fmt = cur.fetchone()[0]

    cur.execute("SELECT relname \
            FROM pg_class \
            WHERE relname IN (\
                SELECT tablename FROM pg_catalog.pg_tables \
                    WHERE schemaname='%s' AND tablename like '%s_p%%' \
                )\
                AND relname = concat('%s_p', \
                    to_char(current_timestamp - '1 day'::interval, '%s'))\
            ORDER BY relname;" % (args.schema, args.table, args.table, fmt))
    tbl = cur.fetchone()[0]
    tablename = '%s.%s' % (args.schema, tbl)
    #print(tablename)

    cur.execute("SELECT min(%s), max(%s) FROM %s;" % \
            (args.field, args.field, tablename))
    min_value, max_value = cur.fetchone()

    exp = ''
    if min_value:
        exp += '%s >= %d' % (args.field, min_value)
    if max_value:
        if len(exp) > 0:
            exp += ' AND '
        exp += '%s <= %d' % (args.field, max_value)
    #print(exp)

    if len(exp) == 0:
        sys.exit(0)

    constraint_name = '%s_%s_check' % (tbl, args.field)
    q = "ALTER TABLE %s ADD CONSTRAINT %s CHECK (%s) NOT VALID;" % \
            (tablename, constraint_name, exp)
    cur.execute(q)
    conn.commit()
    q = "ALTER TABLE %s VALIDATE CONSTRAINT %s;" % (tablename, constraint_name)
    cur.execute(q)
    conn.commit()

    cur.close()
    conn.close()

if __name__ == '__main__':
    main()
