#!/usr/bin/env python

import logging
import yt.wrapper as yt
import psycopg2
import socket
from psycopg2.extras import RealDictCursor
import time
import logging

def main():
    logging.basicConfig(
        level=logging.DEBUG,
        format='%(asctime)s [%(levelname)s] %(name)s:\t%(message)s')
    log = logging.getLogger('main')

    dt = time.strftime("%Y-%m-%d") 
    table = "//home/mail-logs/mdb/bad-filters/" + dt 
    conn_str = 'dbname=maildb port=5432'
    conn = psycopg2.connect(conn_str)
    log.debug('success on connect to postgresql')
    schema = [
        {"name": "uid",         "type": "int64"},
        {"name": "rule_id",       "type": "int64"},
    ]

    update=u"""
          UPDATE filters.rules SET enabled = false 
          WHERE (uid,rule_id) IN 
          (SELECT r.uid, r.rule_id 
          FROM filters.conditions c 
          JOIN filters.rules r ON (c.uid = r.uid AND c.rule_id = r.rule_id) 
          JOIN filters.actions a ON (r.uid = a.uid AND r.rule_id = a.rule_id) 
          WHERE c.field_type = 'header'
          AND c.field = 'to' 
          AND c.oper = 'contains' 
          AND c.negative 
          AND (ascii(c.pattern) > 255 OR ascii(c.pattern)=182) 
          AND r.created >= '2017-09-10' 
          AND a.oper = 'move' AND a.param = '2'
          AND r.enabled
          )
          """
        
    sql=u"""
          SELECT c.uid, r.rule_id
          FROM filters.conditions c 
          JOIN filters.rules r ON (c.uid = r.uid AND c.rule_id = r.rule_id) 
          JOIN filters.actions a ON (r.uid = a.uid AND r.rule_id = a.rule_id) 
          WHERE c.field_type = 'header' 
          AND c.field = 'to' 
          AND c.oper = 'contains' 
          AND c.negative 
          AND (ascii(c.pattern) > 255 
          OR ascii(c.pattern)=182) 
          AND r.created >= '2017-09-10'
          AND a.oper = 'move' AND a.param = '2'
          AND r.enabled
           """ 
    cur = conn.cursor(cursor_factory=RealDictCursor)
    cur.execute('select pg_is_in_recovery()')
    recovery = cur.fetchone()['pg_is_in_recovery']
    cur.execute(sql)
    if cur.rowcount != 0 and not recovery:
        res = cur.fetchall()
        log.debug('success on fetch ucache')
        yt.update_config({'proxy': {'url': "hahn.yt.yandex.net"}})
        if not yt.exists(table):
            yt.create_table(table, attributes={"schema": schema})
            log.debug('create new yt table')
        try:
            yt.write_table((yt.TablePath(table,append=True)), res, format="json",raw=False)
            log.debug('success on write to yt')
            cur.execute(update)
            log.debug(str(cur.rowcount) + ' filters disabled')
            conn.commit()
        except yt.errors.YtHttpResponseError as e:
            log.error(e)
 
if __name__ == "__main__":
    main()
