#!/usr/bin/env python

import psycopg2
import socket
import json
import re
import requests

def check_user_in_sharpei(uid):
    url = 'http://sharpei.mail.yandex.net/conninfo?uid=%s&mode=all&format=json' % (uid)
    req = requests.get(url)
    if req.status_code == requests.codes.ok:
      return req.json()['name']
    else:
      return 'not_found'

def main():
    shard_name = re.match('[a-z0-9-]+[0-9]+', socket.gethostname()).group(0)
    conn = psycopg2.connect('dbname=maildb connect_timeout=1')
    conn.set_isolation_level(psycopg2.extensions.ISOLATION_LEVEL_AUTOCOMMIT)
    cur = conn.cursor()
    cur.execute("SHOW transaction_read_only;")
    if cur.fetchone()[0] != 'off':
        return None

    cur.execute("SELECT gid FROM pg_prepared_xacts WHERE prepared < now() - INTERVAL '1 minutes'")
    for transaction in cur.fetchall():
        try:
           uid = re.search('(^reg_mdb_u)(\d+)(_s\d+)',transaction[0]).group(2)
           if check_user_in_sharpei(uid) in shard_name:
               cur.execute("COMMIT PREPARED '%s';" % (transaction[0]))
           else:
               cur.execute("ROLLBACK PREPARED '%s';" % (transaction[0]))
        except:
           cur.execute("ROLLBACK PREPARED '%s';" % (transaction[0]))
    cur.close()
    conn.close()
     
if __name__ == '__main__':
    main()
