#!/usr/bin/env python

import psycopg2
import socket

conn_str = 'dbname=maildb connect_timeout=1 user=cron port=6432 host=%s' % socket.getfqdn()
conn = psycopg2.connect(conn_str)
cur = conn.cursor()

def get_users():
    query = u"""SELECT uid 
                FROM mail.users u 
               WHERE NOT EXISTS 
                 (SELECT 1 
                    FROM stats.users_info i 
                  WHERE u.uid=i.uid AND last_update>now()-interval '14 days')
                AND is_here
             """
    cur.execute(query)
    users=cur.fetchall()
    return users

def update_mailbox_size(uid):
    db_size_query = u"""SELECT util.mailbox_size_dynamic(%(uid)s)"""
    cur.execute(db_size_query,{'uid': uid})
    db_size=cur.fetchone()[0]
    storage_size_query = u"""SELECT sum(message_size) FROM mail.folders WHERE uid=%(uid)s"""
    cur.execute(storage_size_query,{'uid': uid})
    storage_size=cur.fetchone()[0]
    query = u"""INSERT INTO stats.users_info
                  (uid, last_update, db_size, storage_size)
                  VALUES (
                    %(uid)s,
                    now(),
                    %(db_size)s,
                    %(storage_size)s
                    )
                 ON CONFLICT (uid) DO UPDATE
                     SET db_size = %(db_size)s,
                         storage_size = %(storage_size)s,
                         last_update = now()
             """
    cur.execute(query,{'uid': uid, 'db_size': db_size, 'storage_size': storage_size})

def main():
   cur.execute("show transaction_read_only;")
   if 'off' in str(cur.fetchone()[0]):
       i = 0
       for user in get_users():
         i += 1
         update_mailbox_size(user)
         if i%100==0:
           conn.commit()
       conn.commit()
       conn.close


if __name__ == '__main__':
    main()
