#!/usr/bin/env python

import socket
import time
import psycopg2
import sys
import os
import json
import datetime
import re

me = sys.argv[0].split('/')[-1].split('.')[0] 
hostname = socket.gethostname()
hostname_s = hostname.replace('.', '_')
current_ts = int(time.time())
gr_prefix = "mail.pg"

user = 'monitor'
password = ''

if 'xdb' not in hostname_s:
    sys.exit(0)

with open(os.path.expanduser("~/.pgpass")) as pgpass:
    for line in pgpass:
        tokens = line.rstrip().split(':')
        if tokens[3] == user:
            password = tokens[4]
            break

conn = psycopg2.connect('host=localhost port=5432 dbname=maildb ' +
                        'user=%s password=%s ' % (user, password) +
                        'connect_timeout=1')

cur = conn.cursor()
cur.execute("SHOW transaction_read_only;")
transaction_readonly = cur.fetchone()[0]

if str(transaction_readonly) != 'off':
    sys.exit(0)

prev_path = os.path.expanduser('/tmp/pg_maildb_change_log.prev')
if os.path.exists(prev_path):
    with open(prev_path, 'r') as f:
        try:
            prev_cid = json.loads(''.join(f.readlines()))
            cur.execute("SELECT max(cid) FROM mail.change_log;")
            current_cid = cur.fetchone()[0]

            cur.execute("SELECT type, count(1) FROM mail.change_log WHERE" +
                        " cid BETWEEN 1 + " + json.dumps(prev_cid) +
                        " AND " +  str(current_cid) + " GROUP BY TYPE;")
            for res in cur.fetchall():
                print("%s.%s.changelog.%s %d %d" % (gr_prefix, hostname_s,
                         res[0].replace('-','_'), res[1], current_ts))

            if re.match('xdb[0-9]{4}[a-z].*', hostname_s):
                cur.execute("SELECT count(distinct(uid)) FROM mail.change_log"
                            " WHERE db_user NOT IN ('mxfront', 'mxback',"
                            " 'transfer', 'cron') AND uid IN"
                            " (SELECT uid FROM mail.users WHERE is_here);")
                res = int(cur.fetchone()[0])
                print("%s.%s.changelog.alived_users_in_cold %d "
                      "%d" % (gr_prefix, hostname_s, res, current_ts))

            with open(prev_path, 'w') as f:
                f.write(str(current_cid))
        except Exception:
            pass
else:
    with open(prev_path, 'w') as f:
        try:
            cur.execute("SELECT max(cid) FROM mail.change_log;")
            current_cid = cur.fetchone()[0]
            f.write(str(current_cid))
        except Exception:
            pass
