#!/usr/bin/env python

import socket
import time
import psycopg2
import sys
import os

me = sys.argv[0].split('/')[-1].split('.')[0]
hostname = socket.gethostname()
hostname_s = hostname.replace('.', '_')
current_ts = int(time.time())
gr_prefix = "mail.pg"

user = 'monitor'
password = ''

if 'xdb' not in hostname_s:
    sys.exit(0)

with open(os.path.expanduser("~/.pgpass")) as pgpass:
    for line in pgpass:
        tokens = line.rstrip().split(':')
        if tokens[3] == user:
            password = tokens[4]
            break

conn = psycopg2.connect('host=localhost port=5432 dbname=maildb ' +
                        'user=%s password=%s ' % (user, password) +
                        'connect_timeout=1')

cur = conn.cursor()
cur.execute("SHOW transaction_read_only;")
transaction_readonly = cur.fetchone()[0]

if str(transaction_readonly) != 'off':
    sys.exit(0)

cur.execute("SELECT count(from_uid) FROM mail.transfer_info"
            " WHERE to_db LIKE 'oracle:%' AND transfer_end > "
            "current_timestamp - '7 days'::interval;")
res = int(cur.fetchone()[0])
print("%s.%s.transfer_info.returned_to_oracle %d %d" % (gr_prefix, hostname_s,
                                                        res, current_ts))
