{% from "components/postgres/pg.jinja" import pg with context %}
#!/usr/bin/env python

{% if salt['grains.get']('os') == 'Ubuntu' %}
    {% set prefix = '/var/lib/postgresql' %}
{% else %}
    {% set prefix = '/var/lib/pgsql' %}
{% endif %}

import psycopg2
import urllib
import socket
import json
import re
import os

sharpei_password = '{{ salt['pillar.get']('data:config:pgusers:sharpei:password', '') }}'
usage_percent=100
can_transfer_to='false'

def set_la(shard_id,load_average):
    master_host = get_master_from_group('mail_sharpei', 'sharddb')
    conn = psycopg2.connect('host=%s port=6432 dbname=sharddb user=sharpei '
                            'password=%s connect_timeout=1' % \
                            (master_host, sharpei_password))
    cur = conn.cursor()
    if get_disk_usage() < 60:
        can_transfer_to='true'
    else:
        can_transfer_to='false'
    sql=u"""
    INSERT INTO shards.shards_load (shard_id,load_average,can_transfer_to)
    VALUES (%(shard_id)s,%(load_average)s,%(can_transfer_to)s)
    ON CONFLICT (shard_id)
    DO UPDATE SET load_average=%(load_average)s,
                  can_transfer_to=%(can_transfer_to)s;
    """
    cur.execute(sql,{'shard_id': shard_id, 'load_average': load_average,'can_transfer_to': can_transfer_to})
    conn.commit()
    conn.close()

def get_master_from_group(group, dbname):
    m = urllib.urlopen('http://c.yandex-team.ru/api/groups2hosts/%s?fields='
                       'fqdn' % group ).readlines()
    master = None
    try:
        for host in m:
            conn = psycopg2.connect('host=%s port=6432 dbname=%s user=sharpei '
                                    'password=%s connect_timeout=1' % \
                                    (host, dbname, sharpei_password))
            cur = conn.cursor()
            cur.execute("SELECT master FROM repl_mon;")
            master = str(cur.fetchone()[0])
            cur.close()
            conn.close()
            if master:
                return master
    except Exception as err:
        print(err)
        pass

def get_shard_id():
    url =  '{{ salt['pillar.get']('data:sharpei_url', 'http://sharpei.mail.yandex.net/v2/stat') }}'
    res = json.loads(urllib.urlopen(url).read())
    shard_name = re.match('[a-z0-9-]+[0-9]+', socket.gethostname()).group(0)
    for k, v in res.items():
        if v['name'] == shard_name:
            return int(k)
    return None

def get_la():
    load_average=os.getloadavg()[0]
    return load_average

def get_disk_usage():
    data = os.statvfs('{{ pg.data }}')
    data_total = (data.f_blocks * data.f_frsize)
    data_used = (data.f_blocks - data.f_bfree) * data.f_frsize
    usage_percent = (float(data_used) / data_total) * 100
    return usage_percent

def main():
    conn = psycopg2.connect('dbname=maildb connect_timeout=1')
    cur = conn.cursor()
    cur.execute("SHOW transaction_read_only;")
    if cur.fetchone()[0] != 'off':
        return None
    cur.close()
    conn.close()
    magic_number = get_disk_usage()
    set_la(get_shard_id(), magic_number)

if __name__ == '__main__':
    main()
