{% if salt['pillar.get']('yandex:environment', 'dev') in ('prod', 'qa') %}
    {% set sharpei_host = 'sharpei02g.mail.yandex.net' %}
{% elif salt['pillar.get']('yandex:environment', 'dev') == 'load'%}
    {% set sharpei_host = 'sharpei-load01g.mail.yandex.net' %}
{% else %}
    {% set sharpei_host = 'sharpei-test02g.cmail.yandex.net' %}
{% endif %}

BEGIN;

CREATE SERVER sharddb FOREIGN DATA WRAPPER postgres_fdw
    OPTIONS (dbname 'sharddb', host '{{ sharpei_host }}', port '6432', updatable 'false');

CREATE USER MAPPING FOR PUBLIC SERVER sharddb
    OPTIONS (user 'sharpei', password '{{ salt['pillar.get']('data:config:pgusers:sharpei:password', '') }}');
ALTER USER MAPPING FOR PUBLIC SERVER sharddb
    OPTIONS (set user 'sharpei', set password '{{ salt['pillar.get']('data:config:pgusers:sharpei:password', '') }}');

CREATE FOREIGN TABLE IF NOT EXISTS sharpei_users
    (
      uid bigint,
      shard_id int
    )
    SERVER sharddb
        OPTIONS (table_name 'users',schema_name 'shards', use_remote_estimate 'true');

COMMIT;
