#!/usr/bin/env python

import psycopg2
import urllib
import socket
import json
import re

sharpei_password = '{{ salt['pillar.get']('data:config:pgusers:sharpei:password', '') }}'

def add_users_to_transfer(uids, shard_from):
    master_host = get_master_from_group('mail_mopsdb', 'huskydb')
    conn = psycopg2.connect('host=%s port=6432 dbname=huskydb user=sharpei '
                            'password=%s connect_timeout=1' % \
                            (master_host, sharpei_password))
    cur = conn.cursor()
    count = 0
    for uid in uids:
        cur.execute("INSERT INTO transfer.users_in_dogsleds (uid, task_args, priority) "
                    "SELECT %s, code.make_transfer_args("
                    "'postgre:%s', 'postgre:warm', false, false), -100 "
                    "WHERE NOT EXISTS (SELECT 1 FROM transfer.users_in_dogsleds "
                    "WHERE uid=%s AND status IN ('pending','in_progress')  AND task='transfer')"  % \
                    (uid, shard_from,uid))
        count += 1
        if count >= 10:
            conn.commit()
            count = 0
    conn.commit()
    conn.close()

def get_master_from_group(group, dbname):
    m = urllib.urlopen('http://c.yandex-team.ru/api/groups2hosts/%s?fields='
                       'fqdn' % group ).readlines()
    master = None
    try:
        for host in m:
            conn = psycopg2.connect('host=%s port=6432 dbname=%s user=sharpei '
                                    'password=%s connect_timeout=1' % \
                                    (host, dbname, sharpei_password))
            cur = conn.cursor()
            cur.execute("SELECT master FROM repl_mon;")
            master = str(cur.fetchone()[0])
            cur.close()
            conn.close()
            if master:
                return master
    except Exception as err:
        print(err)
        pass

def get_shard_id():
    url = 'http://sharpei.mail.yandex.net/v2/stat'
    res = json.loads(urllib.urlopen(url).read())
    shard_name = re.match('[a-z0-9-]+[0-9]+', socket.gethostname()).group(0)
    for k, v in res.items():
        if v['name'] == shard_name:
            return int(k)
    return None

def main():
    conn = psycopg2.connect('dbname=maildb connect_timeout=1')
    cur = conn.cursor()
    cur.execute("SHOW transaction_read_only;")
    if cur.fetchone()[0] != 'off':
        return None

    cur.execute("SELECT distinct(u.uid) AS uid "
                "    FROM mail.change_log cl "
                "        JOIN mail.users u ON (cl.uid = u.uid) "
                "  WHERE cl.db_user NOT IN ('mxfront', 'mxback', 'transfer', 'cron') "
                "    AND u.is_here;")
    uids = [uid[0] for uid in cur.fetchall()]
    cur.close()
    conn.close()

    add_users_to_transfer(uids, get_shard_id())

if __name__ == '__main__':
    main()
