{% from "components/postgres/pg.jinja" import pg with context %}

include:
    - .code
    - .mdb-metrics
    - components.monrun2.maildb

pgxxhash:
    pkg.installed:
        - name: postgresql-{{ pg.version.major }}-pgxxhash
        - version: '31-d393a23'

yamail-maildb-cron:
    pkg.installed:
        - version: '57.ed3c561'
        - require:
            - file: /etc/maildb_cron/config.yaml

/etc/maildb_cron/config.yaml:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/maildb/conf/maildb_cron_config.yaml
        - makedirs: True

/etc/cron.d/maildb_cron:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/maildb/conf/maildb_cron
        - user: root
        - group: root
        - mode: 644
        - watch_in:
            - service: pg-common-configs-crond-reload

/etc/cron.yandex/clear_stats.py:
    file.absent

/etc/cron.d/clear_stats:
    file.absent

/usr/local/yandex/pg_connection_limits.sql:
    file.absent

/var/log/maildb_cron:
    file.directory:
        - user: root
        - group: root

/var/run/maildb_cron:
    file.directory:
        - user: root
        - group: root

/etc/cron.yandex/mailbox_size.py:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/maildb/conf/mailbox_size.py
        - user: root
        - group: root
        - mode: 744
        - require:
            - file: /etc/cron.yandex

/etc/cron.yandex/add_change_log_check_constraint.py:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/maildb/conf/add_change_log_check_constraint.py
        - user: postgres
        - group: postgres
        - mode: 744
        - require:
            - file: /etc/cron.yandex

/etc/cron.d/add_change_log_check_constraint:
    file.managed:
        - source: salt://components/pg-dbs/maildb/conf/add_change_log_check_constraint.cron.d
        - user: root
        - group: root
        - mode: 644
        - watch_in:
            - service: pg-common-configs-crond-reload

{% if salt['pillar.get']('data:auto_transfer', False) %}
/etc/cron.yandex/transfer_active_from_cold.py:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/maildb/conf/transfer_active_from_cold.py
        - user: postgres
        - group: postgres
        - mode: 744
        - require:
            - file: /etc/cron.yandex

/etc/cron.d/transfer_active_from_cold:
    file.managed:
        - source: salt://components/pg-dbs/maildb/conf/transfer_active_from_cold.cron.d
        - user: root
        - group: root
        - mode: 644
        - watch_in:
            - service: pg-common-configs-crond-reload
{% endif %}

/etc/cron.yandex/set_la_yaqt.py:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/maildb/conf/set_la_yaqt.py
        - user: postgres
        - group: postgres
        - mode: 744
        - require:
            - file: /etc/cron.yandex

/etc/cron.d/set_la_yaqt.py:
    file.managed:
        - source: salt://components/pg-dbs/maildb/conf/set_la_yaqt.cron.d
        - user: root
        - group: root
        - mode: 644
        - watch_in:
            - service: pg-common-configs-crond-reload

/etc/cron.yandex/end_prepared_transaction.py:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/maildb/conf/end_prepared_transaction.py
        - user: postgres
        - group: postgres
        - mode: 744
        - require:
            - file: /etc/cron.yandex

/etc/cron.d/end_prepared_transaction:
    file.managed:
        - source: salt://components/pg-dbs/maildb/conf/end_prepared_transaction.cron.d
        - user: root
        - group: root
        - mode: 644
        - watch_in:
            - service: pg-common-configs-crond-reload

/usr/share/graphite-client/checks/maildb_change_log.py:
    file.absent

/usr/share/graphite-client/checks/maildb_transfer_info.py:
    file.absent

{% if salt['grains.get']('os') != 'Ubuntu' %}
{% for conf in ['storage_delete_queue','users_here','users_data_version','stat_statments','total_messages'] %}
postgres-metrics-{{ conf }}-config:
    file.managed:
        - name: /etc/postgres-metrics.conf.d/available/{{ conf }}.conf
        - template: jinja
        - source: salt://{{ slspath }}/conf/postgres-metrics.conf.d/{{ conf }}.conf
        - watch_in:
            - service: postgres-metrics-service
postgres-metrics-{{ conf }}-link:
    file.symlink:
        - name: /etc/postgres-metrics.conf.d/enabled/{{ conf }}.conf
        - target: /etc/postgres-metrics.conf.d/available/{{ conf }}.conf
        - watch_in:
            - service: postgres-metrics-service
{% endfor %}
{% endif %}

{% if salt['pillar.get']('data:yt:ucache', False ) %}
/etc/logrotate.d/mdb_ucache_yt:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/maildb/conf/mdb_ucache_yt.logrotate
        - mode: 644
        - user: root
        - group: root

/etc/cron.yandex/mdb_ucache_yt.py:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/maildb/conf/mdb_ucache_yt.py
        - user: postgres
        - group: postgres
        - mode: 744
        - require:
            - file: /etc/cron.yandex

/etc/cron.yandex/bad_filters.py:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/maildb/conf/bad_filters.py
        - user: postgres
        - group: postgres
        - mode: 744
        - require:
            - file: /etc/cron.yandex


/var/log/mdb_ucache_yt.log:
    file.managed:
        - user: postgres
        - group: postgres
        - replace: False
        - mode: 640

yt-python:
    pkg.installed:
{% if salt['grains.get']('os') == 'Ubuntu' %}
        - name: yandex-yt-python 
        - version: '0.8.11-0'
{% else %}
        - name: yandex-yt 
        - version: '0.8.5-5yandex.el6'
{% endif %}


{{pg.prefix}}/.yt/token:
    file.managed:
        - template: jinja
        - user: postgres
        - group: postgres
        - dir_mode: 0700
        - makedirs: True
        - mode: 400
        - contents_pillar: data:config:mdb-yt-token
{% endif %}

/etc/cron.yandex/clean_storage_delete_queue.py:
    file.absent
