{% set dbname = 'mopsdb' %}
{% set databases = salt['pillar.get']('data:mopsdb:databases', ['mopsdb']) %}
{% set target = salt['pillar.get']('data:mopsdb:target', 'latest') %}
{% set path = salt['pillar.get']('data:dbfiles_path', '/usr/local/yandex/') %}

{# Remember that the order is important! #}
{% 
    set sqls = [
        'common/dynamic_query.sql',
        'common/is_master.sql',
        'common/check_partitions.sql'
    ]
%}

{% for sql in sqls %}
{{ dbname + path + sql }}:
    file.managed:
        - source: salt://components/pg-code/{{ sql }}
        - name: {{ path + sql }}
        - user: postgres
        - template: jinja
        - mode: 744
        - makedirs: True
        - require:
            - service: postgresql-service
{% endfor %}

{{ path + dbname }}:
    file.recurse:
        - source: salt://components/pg-code/{{ dbname }}
        - user: postgres
        - template: jinja
        - dir_mode: 755
        - file_mode: 744
        - makedirs: True
        - clean: True
        - require:
            - service: postgresql-service
        - defaults:
            default_dbname: {{ dbname }}

{% for database in databases %}
{% set sql = 'common/init_operation_' + database + '.sql' %}
{{ path + sql }}:
    file.managed:
        - source: salt://components/pg-code/common/init_operation.sql
        - user: postgres
        - template: jinja
        - mode: 744
        - makedirs: True
        - require:
            - service: postgresql-service
        - defaults:
            default_dbname: {{ database }}

{% if salt['grains.get']('pg') and 'role' in salt['grains.get']('pg').keys() and salt['grains.get']('pg')['role'] == 'master' %}

create_db_{{ database }}:
    postgres_database.present:
        - name: {{ database }}
        - user: postgres
        - require:
            - cmd: postgresql-service
            - postgres_user: postgres-user-mops
            - pkg: pg_partman

create_repl_mon_fdw_{{ database }}:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/repl_mon.sql
        - maintenance_db: {{ database }}
        - require:
            - postgres_database: create_db_{{ database }}
            - file: /usr/local/yandex/sqls/repl_mon.sql
        - unless:
            - -c "SELECT c.relname FROM pg_catalog.pg_foreign_table ft INNER JOIN pg_catalog.pg_class c ON c.oid = ft.ftrelid;" | grep repl_mon

{{ database + '-schemas-apply' }}:
    postgresql_schema.applied:
        - name: {{ dbname }}
        - target: {{ target }}
        - conn: 'dbname={{ database }}\ user=postgres\ connect_timeout=1'
        - callbacks:
            afterAll:
                - {{ path + dbname }}/code
{% for sql in sqls %}
                - {{ path + sql }}
{% endfor %}
                - {{ path }}common/init_operation_{{ database }}.sql
                - {{ path + dbname }}/grants
        - require:
            - postgres_database: create_db_{{ database }}
            - pkg: yamail-pgmigrate
            - file: {{ path + dbname }}
            - file: {{ path }}common/init_operation_{{ database }}.sql
{% for sql in sqls %}
            - file: {{ path + sql }}
{% endfor %}
{% endif %}
{% endfor %}
