#!/bin/bash

set -e
set -x

VERSION=$(/usr/bin/psql -At 'dbname=postgres port=6432 host=localhost user=monitor' -c "SELECT regexp_matches(version(), E'PostgreSQL ([0-9]*.[0-9]*)')" | tr -d '{}')

if [ -f /var/lib/pgsql/$VERSION/data/recovery.conf ]
then
    master=`grep '^primary_conninfo' /var/lib/pgsql/$VERSION/data/recovery.conf | sed -e 's/.*host=\(\S*\).*/\1/'`
    sed -i /etc/pgbouncer/pgbouncer.ini -e "s/^\* = host=localhost$/\* = host=$master port=6432/"
fi
