#!/usr/bin/env python

from __future__ import absolute_import, print_function, unicode_literals

import os
import socket
import sys
import time

me = sys.argv[0].split('/')[-1].split('.')[0]
hostname = socket.gethostname()
shard = hostname.split('.')[0][:-1]
current_ts = int(time.time())
prefix = "%s.%s.db" % ('mail.pg.rpopdb', shard)

file_mtime = os.path.getmtime('/tmp/pg_rpopdb_old_collectors.status')

if file_mtime > current_ts - 300:
    with open('/tmp/pg_rpopdb_old_collectors.status') as f:
        for l in f.readlines():
            if l:
                print("%s.%s %d" % (prefix, l.rstrip(), current_ts))
