#!/usr/bin/env python

from __future__ import absolute_import, print_function, unicode_literals

import os

import psycopg2

user = 'monitor'
password = ''

with open(os.path.expanduser("~/.pgpass")) as pgpass:
    for line in pgpass:
        tokens = line.rstrip().split(':')
        if tokens[3] == user:
            password = tokens[4]
            break

conn = psycopg2.connect('host=localhost port=5432 dbname=rpopdb ' +
                        'user=%s password=%s ' % (user, password) +
                        'connect_timeout=1')
cur = conn.cursor()

res = cur.execute("show transaction_read_only")
tr_readonly = cur.fetchone()

if tr_readonly[0] == "on":
    with open('/tmp/pg_rpopdb_old_collectors.status', 'w') as f:
        cur.execute("select cnt from monitor.bad_rpop_total")
        f.write("%s %d\n" % ("old_collectors", cur.fetchone()[0]))

        cur.execute("select cnt from monitor.bad_rpop_ng")
        f.write("%s %d\n" % ("old_collectors_ng", cur.fetchone()[0]))

        cur.execute("select cnt, owner from monitor.bad_rpop_by_rpopper")
        for result in cur.fetchall():
            f.write("%s.%s %d\n" % ("old_rpopper", result[1].replace('.', '_'),
                                    result[0]))

        cur.execute("select cnt, server from monitor.bad_rpop_by_server")
        for result in cur.fetchall():
            f.write("%s.%s %d\n" % ("old_server", result[1].replace('.', '_'),
                                    result[0]))

        cur.execute("select cnt, server from monitor.bad_rpop_ng_by_server")
        for result in cur.fetchall():
            f.write("%s.%s %d\n" % ("old_server_ng", result[1].replace('.', '_'),
                                    result[0]))

        cur.execute("select cnt, owner from monitor.bad_rpop_ng_by_rpopper")
        for result in cur.fetchall():
            f.write("%s.%s %d\n" % ("old_rpopper_ng", result[1].replace('.', '_'),
                                    result[0]))
