{% from "components/postgres/pg.jinja" import pg with context %}

{% set dbname = 's3db' %}
{% set target = salt['pillar.get']('data:s3db:target', 'latest') %}
{% set path = salt['pillar.get']('data:dbfiles_path', '/usr/local/yandex/') %}
{% set code_versions = salt['pillar.get']('data:s3db:versions', [1, ]) %}


pathman:
    pkg.installed:
{% if salt['grains.get']('os') == 'Ubuntu' %}
        - name: postgresql-{{ pg.version.major }}-pathman
{% else %}
        - name: pg_pathman{{ pg.version.short }}
{% endif %}
        - version: 1.4-2yandex.db001cb
        - require_in:
            - cmd: postgresql-service


{# Remember that the order is important! #}
{%
    set sqls = [
        'common/dynamic_query.sql',
        'common/is_master.sql'
    ]
%}

{% for sql in sqls %}
{{ dbname + path + sql }}:
    file.managed:
        - source: salt://components/pg-code/{{ sql }}
        - name: {{ path + sql }}
        - user: postgres
        - template: jinja
        - mode: 744
        - makedirs: True
        - require:
            - cmd: postgresql-service
{% endfor %}

{{ path + dbname }}:
    file.recurse:
        - source: salt://components/pg-code/{{ dbname }}
        - user: postgres
        - template: jinja
        - dir_mode: 755
        - file_mode: 744
        - makedirs: True
        - clean: True
        - exclude_pat: 'E@(.git)|(tests)|(docker)'
        - require:
            - service: postgresql-service
        - defaults:
            default_dbname: {{ dbname }}

{% if salt['grains.get']('pg') and 'role' in salt['grains.get']('pg').keys() and salt['grains.get']('pg')['role'] == 'master' %}

create_db_{{ dbname }}:
    postgres_database.present:
        - name: {{ dbname }}
        - user: postgres
        - require:
            - cmd: postgresql-service
            - postgres_user: postgres-user-s3api

create_repl_mon_fdw_{{ dbname }}:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/repl_mon.sql
        - maintenance_db: {{ dbname }}
        - require:
            - postgres_database: create_db_{{ dbname }}
            - file: /usr/local/yandex/sqls/repl_mon.sql
        - unless:
            - -c "SELECT c.relname FROM pg_catalog.pg_foreign_table ft INNER JOIN pg_catalog.pg_class c ON c.oid = ft.ftrelid;" | grep repl_mon

{{ dbname + '-schemas-apply' }}:
    postgresql_schema.applied:
        - name: {{ dbname }}
        - target: {{ target }}
        - conn: 'dbname={{ dbname }}\ user=postgres\ connect_timeout=1'
        - callbacks:
            afterAll:
{% for sql in sqls %}
                - {{ path + sql }}
{% endfor %}
{% for version in code_versions %}
                - {{ path + dbname }}/v{{ version }}/code
                - {{ path + dbname }}/v{{ version }}/impl
                - {{ path + dbname }}/v{{ version }}/util
                - {{ path + dbname }}/v{{ version }}/grants
{% endfor %}
        - require:
            - postgres_database: create_db_{{ dbname }}
            - pkg: yamail-pgmigrate
            - file: {{ path + dbname }}
{% for sql in sqls %}
            - file: {{ path + sql }}
            - pkg: pathman
{% endfor %}
{% endif %}
