{% set proxy = salt['pillar.get']('data:s3db:chunk_splitter:proxy', salt['pillar.get']('data:s3proxy')) %}
{% set db = salt['pillar.get']('data:s3db:chunk_splitter:db', salt['pillar.get']('data:s3db:db', 'host=localhost port=6432 dbname=s3db user=s3util')) %}
{% set threshold = salt['pillar.get']('data:s3db:chunk_splitter:threshold') %}
{% set user = salt['pillar.get']('data:s3db:chunk_splitter:user', salt['pillar.get']('data:s3db:user', 's3util')) %}
{% if salt['pillar.get']('data:s3db:chunk_splitter:enable', True) %}
*/5 * * * * s3 sleep $[$RANDOM \% 150]; flock -n /tmp/chunk_splitter.lock /usr/local/yandex/s3/s3db/chunk_splitter.py -p '{{ proxy }}' -d '{{ db }}' -u {{ user }} {% if threshold %} -t '{{ threshold }}' {% endif %} >> /var/log/s3/chunk_splitter.log 2>&1
{% endif %}
