include:
    - .code
{% if salt['grains.get']('os') == 'Ubuntu' %}
    - .mdb-metrics
{% endif %}

/usr/local/yandex/s3/util:
    file.recurse:
        - source: salt://components/pg-code/pgproxy/s3db/scripts/util
        - user: s3
        - group: s3
        - template: jinja
        - dir_mode: 755
        - file_mode: 744
        - makedirs: True
        - clean: True
        - exclude_pat: 'E@(.pyc)'
        - require:
            - user: s3-user

/usr/local/yandex/s3/s3db:
    file.recurse:
        - source: salt://components/pg-code/pgproxy/s3db/scripts/s3db
        - user: s3
        - group: s3
        - template: jinja
        - dir_mode: 755
        - file_mode: 744
        - makedirs: True
        - clean: True
        - require:
            - user: s3-user

{% for script in ['chunk_splitter', 'update_chunks_counters'] %}
/etc/cron.d/{{ script }}:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/{{ script }}.cron.d
        - user: root
        - group: root
        - mode: 644
        - watch_in:
            - service: pg-common-configs-crond-reload

/etc/logrotate.d/{{ script }}:
    file.managed:
        - source: salt://{{ slspath }}/conf/common.logrotate
        - template: jinja
        - defaults:
            script: {{ script }}
        - mode: 644
        - user: root
        - group: root
{% endfor %}

s3-user:
  user.present:
    - name: s3
    - gid_from_name: True
    - createhome: True
    - empty_password: False
    - shell: /bin/false
    - system: True

/home/s3/.pgpass:
  file.managed:
    - source: salt://{{ slspath }}/conf/pgpass
    - template: jinja
    - user: s3
    - group: s3
    - mode: 600
    - require:
      - user: s3-user

/var/log/s3:
    file.directory:
        - user: s3
        - group: s3
        - require:
            - user: s3-user

/var/run/s3:
    file.directory:
        - user: s3
        - group: s3
        - require:
            - user: s3-user

{% if salt['grains.get']('os') != 'Ubuntu' %}
{% for conf in ['s3db_chunks', 's3db_schema_version', 's3db_chunks_counters_queue', 's3db_storage_delete_queue'] %}
postgres-metrics-{{ conf }}-config:
    file.managed:
        - name: /etc/postgres-metrics.conf.d/available/{{ conf }}.conf
        - template: jinja
        - source: salt://{{ slspath }}/conf/postgres-metrics.conf.d/{{ conf }}.conf
        - watch_in:
            - service: postgres-metrics-service
postgres-metrics-{{ conf }}-link:
    file.symlink:
        - name: /etc/postgres-metrics.conf.d/enabled/{{ conf }}.conf
        - target: /etc/postgres-metrics.conf.d/available/{{ conf }}.conf
        - watch_in:
            - service: postgres-metrics-service
{% endfor %}
{% endif %}

