{% set proxy = salt['pillar.get']('data:s3meta:chunk_mover:proxy', salt['pillar.get']('data:s3proxy')) %}
{% set db = salt['pillar.get']('data:s3meta:chunk_mover:db', salt['pillar.get']('data:s3meta:db', 'host=localhost port=6432 dbname=s3meta user=s3util')) %}
{% set user = salt['pillar.get']('data:s3meta:chunk_mover:user', salt['pillar.get']('data:s3meta:user', 's3util')) %}
{% set threshold = salt['pillar.get']('data:s3meta:chunk_mover:threshold') %}
{% set max_objects = salt['pillar.get']('data:s3meta:chunk_mover:max_objects') %}
{% set min_objects = salt['pillar.get']('data:s3meta:chunk_mover:min_objects') %}
{% set delay = salt['pillar.get']('data:s3meta:chunk_mover:delay') %}
{% if salt['pillar.get']('data:s3meta:chunk_mover:enable', True) %}
0 * * * * s3 sleep $[$RANDOM \% 600]; flock -n /tmp/chunk_mover.lock /usr/local/yandex/s3/s3meta/chunk_mover.py -p '{{ proxy }}' -d '{{ db }}' -u {{ user }} {% if threshold %} --diff-threshold={{ threshold }} {% endif %} {% if max_objects %} --max-objects={{ max_objects }} {% endif %} {% if min_objects %} --min-objects={{ min_objects }} {% endif %} {% if delay %} --delay='{{ delay }}' {% endif %} >> /var/log/s3/chunk_mover.log 2>&1
{% endif %}
