{% set dbname = 'salt' %}
{% set target = salt['pillar.get']('data:salt_web:target', 'latest') %}
{% set path = salt['pillar.get']('data:dbfiles_path', '/usr/local/yandex/') %}

{# Remember that the order is important! #}
{% 
    set sqls = [
        'common/dynamic_query.sql',
        'common/is_master.sql'
    ]
%}

{% for sql in sqls %}
{{ dbname + path + sql }}:
    file.managed:
        - source: salt://components/pg-code/{{ sql }}
        - name: {{ path + sql }}
        - user: postgres
        - template: jinja
        - mode: 744
        - makedirs: True
        - require:
            - cmd: postgresql-service
{% endfor %}

{{ path + dbname }}:
    file.recurse:
        - source: salt://components/pg-code/{{ dbname }}
        - user: postgres
        - template: jinja
        - dir_mode: 755
        - file_mode: 744
        - makedirs: True
        - clean: True
        - require:
            - service: postgresql-service
        - defaults:
            default_dbname: {{ dbname }}

{% if salt['grains.get']('pg') and 'role' in salt['grains.get']('pg').keys() and salt['grains.get']('pg')['role'] == 'master' %}

create_db_{{ dbname }}:
    postgres_database.present:
        - name: {{ dbname }}
        - user: postgres
        - require:
            - cmd: postgresql-service
            - postgres_user: postgres-user-salt_event_reporter

create_repl_mon_fdw_{{ dbname }}:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/repl_mon.sql
        - maintenance_db: {{ dbname }}
        - require:
            - postgres_database: create_db_{{ dbname }}
            - file: /usr/local/yandex/sqls/repl_mon.sql
        - unless:
            - -c "SELECT c.relname FROM pg_catalog.pg_foreign_table ft INNER JOIN pg_catalog.pg_class c ON c.oid = ft.ftrelid;" | grep repl_mon

{{ dbname + '-schemas-apply' }}:
    postgresql_schema.applied:
        - name: {{ dbname }}
        - target: {{ target }}
        - conn: 'dbname={{ dbname }}\ user=postgres\ connect_timeout=1'
        - callbacks:
            afterAll:
{% for sql in sqls %}
                - {{ path + sql }}
{% endfor %}
                - {{ path + dbname }}/grants
        - require:
            - postgres_database: create_db_{{ dbname }}
            - pkg: yamail-pgmigrate
            - file: {{ path + dbname }}
{% for sql in sqls %}
            - file: {{ path + sql }}
{% endfor %}
{% endif %}
