{% from "components/postgres/pg.jinja" import pg with context %}
{% set dbs_dict = {} %}
{% set migrations_path = salt['pillar.get']('data:dbfiles_path', '/usr/local/yandex/unmanaged') %}
{% set databases = salt['pillar.get']('data:unmanaged_dbs', []) %}


{% if salt['grains.get']('os') == 'Ubuntu' %}
include:
    - .mdb-metrics
{% endif %}

{{ migrations_path }}:
    file.recurse:
        - source: salt://components/pg-code/unmanaged
        - user: postgres
        - dir_mode: 755
        - file_mode: 744
        - makedirs: True
        - clean: True
        - require:
            - service: postgresql-service

{% if pg.get('is_master') %}
unmanaged-schemas-apply:
    postgresql_schema.applied:
        - name: unmanaged
        - target: 2
        - conn: 'dbname=postgres\ user=postgres\ connect_timeout=1'
        - callbacks:
            afterAll:
                - {{ migrations_path }}/code
                - {{ migrations_path }}/grants
                - /usr/local/yandex/sqls/show_activity_stats.sql
                - /usr/local/yandex/sqls/unapplied_settings.sql
        - require:
            - pkg: yamail-pgmigrate
            - service: postgresql-service
            - file: {{ migrations_path }}
            - file: /usr/local/yandex/sqls/show_activity_stats.sql
            - file: /usr/local/yandex/sqls/unapplied_settings.sql

{% for user, opts in salt['pillar.get']('data:config:pgusers', {}).items() %}
{% if 'dbaas_auth_user' in opts.get('grants', []) %}
auth-{{ user }}-grant:
    postgresql_cmd.psql_exec:
        - name: 'GRANT dbaas_auth_user TO "{{ user }}";'
        - require:
            - postgresql_schema: unmanaged-schemas-apply
        - unless:
            - -c "SELECT ARRAY(SELECT b.rolname FROM pg_catalog.pg_auth_members m JOIN pg_catalog.pg_roles b ON (m.roleid = b.oid) WHERE m.member = r.oid) AS roles FROM pg_catalog.pg_roles r WHERE rolname = '{{ user }}';" | grep dbaas_auth_user
        - onlyif:
            - -c "select rolname from pg_roles where rolname = '{{ user }}'" | grep {{ user }}
{% endif %}
{% endfor %}
{% endif %}

{% for dbDict in databases %}
{% set database=dbDict.keys()[0] %}
{% do dbs_dict.update({database: True}) %}
{% if pg.get('is_master') %}

{% set user=salt['pillar.get']('data:unmanaged_dbs:' + database + ':user', database[:-2] if 'db' in database else database) %}
{% set extensions=salt['pillar.get']('data:unmanaged_dbs:' + database + ':extensions', []) %}
{% set lc_collate=salt['pillar.get']('data:unmanaged_dbs:' + database + ':lc_collate', 'C') %}
{% set lc_ctype=salt['pillar.get']('data:unmanaged_dbs:' + database + ':lc_ctype', 'C') %}

create_db_{{ database }}:
    postgres_database.present:
        - name: {{ database }}
        - user: postgres
        - owner: {{ user }}
        - lc_ctype: {{ lc_ctype}}
        - lc_collate: {{ lc_collate }}
        - template: template0
        - require:
            - cmd: postgresql-service
            - postgres_user: postgres-user-{{ user }}

monitor_public_grant_{{ database }}:
    postgresql_cmd.psql_exec:
        - name: 'GRANT USAGE ON SCHEMA public TO monitor; GRANT SELECT ON ALL TABLES IN SCHEMA public TO monitor;'
        - maintenance_db: {{ database }}
        - onchanges:
            - postgres_database: create_db_{{ database }}

{% if pg.version.major_num >= 1000 %}
grant_pg_monitor_to_{{ user }}_{{ database }}:
     postgresql_cmd.psql_exec:
        - name: 'GRANT pg_monitor TO "{{ user }}";'
        - maintenance_db: {{ database }}
        - require:
            - postgres_database: create_db_{{ database }}
        - unless:
            - -c "\dg {{ user }}" | fgrep pg_monitor

grant_pg_signal_backend_to_{{ user }}_{{ database }}:
     postgresql_cmd.psql_exec:
        - name: 'GRANT pg_signal_backend TO "{{ user }}";'
        - maintenance_db: {{ database }}
        - require:
            - postgres_database: create_db_{{ database }}
        - unless:
            - -c "\dg {{ user }}" | fgrep pg_signal_backend
{% endif %}

create_repl_mon_fdw_{{ database }}:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/repl_mon.sql
        - maintenance_db: {{ database }}
        - require:
            - postgres_database: create_db_{{ database }}
            - file: /usr/local/yandex/sqls/repl_mon.sql
        - unless:
            - -c "SELECT c.relname FROM pg_catalog.pg_foreign_table ft INNER JOIN pg_catalog.pg_class c ON c.oid = ft.ftrelid;" | grep repl_mon

bloat-info-functions-unmanaged-{{ database }}:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/bloat_functions.sql
        - maintenance_db: {{ database }}
        - unless:
            - -tA -c "select 't' from pg_proc where proname in ('get_index_bloat_info')" | grep -q "^t"
            - -tA -c "select 't' from pg_proc where proname in ('get_heap_bloat_info')" | grep -q "^t"
        - require:
            - cmd: postgresql-service
            - file: /usr/local/yandex/sqls/bloat_functions.sql
            - postgres_database: create_db_{{ database }}

{% for extension in extensions %}
create_extension_{{ database }}_{{ extension }}:
     postgresql_cmd.psql_exec:
{% if '-' in extension %}
        - name: 'create extension "{{ extension }}"'
{% else %}
        - name: 'create extension {{ extension }}'
{% endif %}
        - maintenance_db: {{ database }}
        - require:
            - postgresql_cmd: create_repl_mon_fdw_{{ database }}
        - unless:
            - -At -c 'select extname from pg_extension' | grep -q {{ extension }}
{% endfor %}
{% endif %}
{% endfor %}

{% for db in salt['grains.get']('pg:databases') %}
{% if db not in dbs_dict %}
drop_db_{{ db }}:
    postgres_database.absent:
        - name: {{ db }}
        - require:
            - cmd: postgresql-service
{% endif %}
{% endfor %}

{% if salt['grains.get']('os') != 'Ubuntu' %}
{% for conf in ['cgroup', 'conns', 'db_size'] %}
postgres-metrics-{{ conf }}-config:
    file.managed:
        - name: /etc/postgres-metrics.conf.d/available/{{ conf }}.conf
        - template: jinja
        - source: salt://{{ slspath }}/conf/{{ conf }}.conf
        - defaults:
            databases: {{ dbs_dict.keys() }}
        - watch_in:
            - service: postgres-metrics-service

postgres-metrics-{{ conf }}-link:
    file.symlink:
        - name: /etc/postgres-metrics.conf.d/enabled/{{ conf }}.conf
        - target: /etc/postgres-metrics.conf.d/available/{{ conf }}.conf
        - watch_in:
            - service: postgres-metrics-service
{% endfor %}
{% endif %}

{% if salt['grains.get']('os') == 'Ubuntu' %}
/etc/cron.d/disk_usage_watcher:
    file.managed:
        - source: salt://{{slspath}}/conf/disk_usage_watcher.cron.d
        - mode: 644
        - template: jinja

/usr/local/yandex/disk_usage_watcher.py:
    file.managed:
        - source: salt://{{slspath}}/conf/disk_usage_watcher.py
        - mode: 755

pyscopg2-packages:
    pkg.installed:
        - pkgs:
            - python3-psycopg2: 2.7.1-2yandex7
{% endif %}

