#!/bin/bash

dbname={{ salt['pillar.get']('data:pg_repack:dbname', 'xivadb') }}
schema={{ salt['pillar.get']('data:pg_repack:schema', 'xiva') }}
table={{ salt['pillar.get']('data:pg_repack:table', 'notifications') }}
retention_period={{ salt['pillar.get']('data:pg_repack:retention_period', '4') }}

query="SELECT relname FROM pg_class \
    WHERE relname IN (\
        SELECT tablename FROM pg_catalog.pg_tables \
        WHERE schemaname='${schema}' AND tablename like '${table}_p%'\
        )\
    AND relname < concat('${table}_p', to_char(current_timestamp - '${retention_period} days'::interval, 'YYYY_MM_DD')) \
    ORDER BY relname;"

for table in `psql -t -A ${dbname} -c "$query"`
do
    psql ${dbname} -c "DROP TABLE ${schema}.${table}"
done
