#!/usr/bin/python

import psycopg2
import time

def bydlog(s):
    print('%s\t%s' % (time.ctime(), s))

def main():
    conn = psycopg2.connect('dbname=xivadb')
    conn.autocommit = True
    cur = conn.cursor()
    cur.execute('SELECT * FROM code.remove_broken_subscriptions();')
    count = cur.fetchone()[0]
    bydlog('code.remove_broken_subscriptions(): Removed %d broken subscriptions.' % ( count ) );

if __name__ == '__main__':
    bydlog('Starting xivadb.xiva.subscriptions broken subscriptions removal proccess.')
    main()
    bydlog('Finished xivadb.xiva.subscriptions broken subscriptions removal proccess.')
