#!/usr/bin/python

import psycopg2
import time

def bydlog(s):
    print('%s\t%s' % (time.ctime(), s))

def main():
    conn = psycopg2.connect('dbname=xivadb')
    conn.autocommit = True
    cur = conn.cursor()
    cur.execute('SELECT * FROM code.return_uid_ranges();')
    uids = cur.fetchone()[0]
    bydlog('Following uid ranges have been selected: ' + str(uids))
    if uids is None:
        uids = [0, 9223372036854775807]

    for i in xrange(0, len(uids)-1):
        bydlog('Started processing uids from %s to %s.' % (str(uids[i]), str(uids[i+1])))
        cur.execute("SELECT code.remove_old_subscriptions('%s','%s');" % (str(uids[i]),\
 str(uids[i+1])))
        count = cur.fetchone()[0]
        bydlog('Removed %s rows while processing uids from %s to %s.' % (str(count), str(uids[i]), str(uids[i+1])))

if __name__ == '__main__':
    bydlog('Starting iteration of cleaning xivadb.xiva.subscriptions.')
    main()
    bydlog('Finished iteration of cleaning xivadb.xiva.subscriptions.')
