/etc/cron.yandex/xivastoredb_vacuum_inactive_partitions.py:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/xivastoredb_vacuum_inactive_partitions.py
        - user: postgres
        - group: postgres
        - mode: 744
        - require:
            - file: /etc/cron.yandex

/etc/cron.d/xivastoredb_vacuum_inactive_partitions:
    file.managed:
        - source: salt://components/pg-dbs/xivadb/conf/xivastoredb_vacuum_inactive_partitions
        - user: root
        - group: root
        - mode: 644
        - watch_in:
            - service: pg-common-configs-crond-reload

/var/log/postgresql-frozenvacuum:
    file.directory:
    - user: root
    - group: postgres
    - dir_mode: 775
    - file_mode: 660
    - recurse:
        - user
        - group
        - mode

/etc/logrotate.d/xivastoredb_vacuum_inactive_partitions:
    file.managed:
        - source: salt://components/pg-dbs/xivadb/conf/vacuum_inactive_partitions.logrotate
        - template: jinja
        - mode: 644
        - user: root
        - group: root
