{% set dbname = salt['pillar.get']('data:dbname', '') %}
/usr/local/yandex/add_cluster_to_sharpei.py:
    file.managed:
        - source: salt://components/postgres/conf/add_cluster_to_sharpei.py
        - template: jinja
        - mode: 755
        - user: postgres
        - group: postgres

{% if salt['pillar.get']('data:add_to_sharpei', False) %}
init_{{ dbname }}_in_sharpei:
    cmd.wait:
        - name: /usr/local/yandex/add_cluster_to_sharpei.py
        - runas: postgres
        - watch:
            - postgres_database: create_db_{{ dbname }}
{% endif %}
