pg-classify-packages:
    pkg.installed:
        - pkgs:
            - pg-classify: 7-1315af4
{% if salt['grains.get']('os') == 'Ubuntu' %}
            - python-daemon: 2.0.5-2yandex6
            - python-lockfile: "1:0.10.2-3yandex5"
{% endif %}

/etc/pg-classify.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/pg-classify.conf
        - require:
            - pkg: pg-classify-packages

pg-classify-restart:
    service:
        - running
        - enable: true
        - name: pg-classify
        - watch:
            - pkg: pg-classify-packages
            - file: /etc/pg-classify.conf
