#!/usr/bin/env python
import psycopg2
import sys
import os
import argparse
import urllib
import yaml
import socket

sharpei_password ='{{ salt['pillar.get']('data:config:pgusers:sharpei:password', '') }}'
master_hostname = socket.gethostbyaddr(socket.gethostname())[0]
shard = master_hostname.split('.')[0][:-1]
db = '{{ salt['pillar.get']('data:dbname', '') }}'

def get_root_dc(hostname):
    dc_letter = hostname.split('.')[0][-1]
    if dc_letter == 'e':
       root_dc = 'IVA'
    elif dc_letter == 'h':
       root_dc = 'SAS'
    elif dc_letter == 'i':
       root_dc = 'MAN'
    elif dc_letter == 'v':
       root_dc = 'VLA'
    elif dc_letter == 'f':
       root_dc = 'MYT'
    return root_dc

def add_instance(replica_hostname, sharpei_master_host, db):
    conn = psycopg2.connect('host=%s port=6432 dbname=sharddb user=sharpei password=%s connect_timeout=1' % (sharpei_master_host, sharpei_password))
    cur = conn.cursor()
    cur.execute("select code.add_instance(%s, %s, 6432, %s, %s)", (master_hostname, replica_hostname, get_root_dc(replica_hostname), db))
    conn.commit()
    print str(cur.fetchone()[0])
    conn.close()

def get_master_sharpei():
    m = urllib.urlopen('http://c.yandex-team.ru/api/groups2hosts/%s?fields=fqdn' %  '{{ salt['pillar.get']('data:sharpei_condgroup', 'mail_sharpei') }}' ).readlines()
    firs_sharpei_host=m[0].rstrip()

    conn = psycopg2.connect('host=%s port=6432 dbname=sharddb user=sharpei password=%s connect_timeout=1' % (firs_sharpei_host, sharpei_password))
    cur = conn.cursor()
    cur.execute("select master from repl_mon;")
    sharpei_master_host = str(cur.fetchone()[0])
    conn.close()
    return sharpei_master_host

def main():
    sharpei_master_host = get_master_sharpei()

    conn = psycopg2.connect('host=%s port=6432 dbname=sharddb user=sharpei password=%s connect_timeout=1' % (sharpei_master_host,sharpei_password))
    cur = conn.cursor()
    cur.execute("select code.add_shard(%s, %s, 6432, %s, %s)", (shard, master_hostname, get_root_dc(master_hostname), db))
    conn.commit()
    conn.close()
    conn = psycopg2.connect('dbname=postgres connect_timeout=1')
    cur = conn.cursor()
    cur.execute("select client_hostname from pg_stat_replication;")
    for replica in cur.fetchall():
        add_instance(replica[0],sharpei_master_host,db)
    conn.close()

if __name__ == '__main__':
    main()
