#!/bin/bash

date=`/bin/date --date=yesterday +%Y%m%d`

bad_backups_count=0
bad_backups=()

backups=(`find /u0 -type f -wholename "*/$date/base.tar.gz"`)
backups_count=${#backups[@]}

index=0
while [ "$index" -lt "$backups_count" ]
do
	tar -tzf ${backups[$index]} >/dev/null 2>&1
	if [ $? -eq 0 ]
	then
		unset backups[$index]
	fi
	let "index = $index + 1"
done

if [ ${#backups[@]} -ne 0 ]
then
	description=`echo "Total: ${#backups[@]}. ${backups[@]}" | sed -e 's/\ /\+/g'`
	check_status="warning"
else
	description="No incosistent backups."
	check_status="ok"
fi

curl "http://golem.yandex-team.ru/api/events/submit.sbml?object=`hostname -f`&eventtype=inconsistent_backups&status=${check_status}&info=$description" >/dev/null 2>&1
echo `date` "$description" >/var/log/check_backups.log
#curl "http://arena2.circus1-ugr.yandex.net:8998/api/events/add_event_proxy?host_name=`hostname -f`&service_name=inconsistent_backups&&do=1&instance_name=&status=${check_status}&description=$description" >/dev/null 2>&1
