#/bin/bash
if [ -f /usr/local/sbin/autodetect_environment ] ; then
    is_virtual_host=0
    . /usr/local/sbin/autodetect_environment >/dev/null 2>&1 || true
    if [ "$is_virtual_host" -eq 1 ] ; then
        exit 0
    fi
fi

if grep 'model name' /proc/cpuinfo | grep -q 'KVM' ; then
    exit 0
elif grep -q 'Booting paravirtualized kernel on KVM' /var/log/dmesg 2>/dev/null ; then
    exit 0
fi

hostname=`hostname -f`
if [[ $hostname == *".mail.yandex.net"* ]] ; then
    fastbone_name="${hostname/.mail.yandex.net/-fb.mail.yandex.net}"
    if [[ `host $fastbone_name` == *"has IPv6 address"* ]] ; then
       if [ -f /etc/sysconfig/network-scripts/ifcfg-vlan740 ] ; then
           exit 0
       else
           /root/bin/create-fastbone-interface.sh
           /sbin/ifup vlan740
       fi
    else
        exit 0
    fi
else
    exit 0
fi
