#!/usr/bin/env python

import platform
import sys

import psycopg2

my_hostname = platform.node()

try:
    conn = psycopg2.connect('dbname=postgres user=monitor connect_timeout=1')
    cur = conn.cursor()
    cur.execute("SELECT master FROM repl_mon;")
    master_host = cur.fetchone()[0]
    if master_host == my_hostname:
        sys.exit(3)

    conn = psycopg2.connect('dbname=postgres user=monitor connect_timeout=1 host=%s' % master_host)
    cur = conn.cursor()
    cur.execute("SELECT * FROM show_sync_replica();")
    sync_replica = cur.fetchone()[0]
    if sync_replica == my_hostname:
        sys.exit(0)
    sys.exit(1)
except Exception as e:
    sys.exit(2)
finally:
    try:
        cur.close()
        conn.close()
    except Exception:
        pass
