#!/usr/bin/env python

import psycopg2
import sys
import argparse
import time

parser = argparse.ArgumentParser()
parser.add_argument('-p', '--port',
                    type=int,
                    default=5432,
                    help='Postgres port')
parser.add_argument('-w', '--wait',
                    type=int,
                    default=60,
                    help='Time to wait before returning error')
parser.add_argument('-v', '--verbose',
                    action="store_true",
                    help='Some logging')
args = parser.parse_args()
start = time.time()

dsn = 'dbname=postgres connect_timeout=1 port=%d' % args.port

while time.time() < start + args.wait:
    try:
        conn = psycopg2.connect(dsn)
        cur = conn.cursor()
        cur.execute('SELECT 42;')
        if cur.fetchone()[0] == 42:
            sys.exit(0)
        raise Exception
    except Exception as err:
        if args.verbose:
            print(time.strftime('%H:%M:%S ') + str(err).rstrip())
        time.sleep(1)
    finally:
        try:
            cur.close()
            conn.close()
        except Exception:
            pass

if args.verbose:
    print('Timeout (%d seconds) expired.' % args.wait)
sys.exit(1)
