#!/usr/bin/python

import subprocess
import argparse
import porto
import sys


def get_porto_connection():
    conn = porto.Connection()
    conn.connect()
    return conn


def get_pids(process_name):
    cmd = "ps -ef | grep '%s' | grep -v porto_attacher" \
        "| grep -v grep | awk '{print $2}'" % process_name
    procesess = subprocess.Popen(
        cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    pids = procesess.communicate()[0].splitlines()
    return pids


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--cpu_limit',
                        type=str,
                        default='1c',
                        help='cpu_limit cores')

    parser.add_argument('-i', '--io_limit',
                        type=int,
                        default=52428800,
                        help='io_limit bytes/s')

    parser.add_argument('-p', '--process_name',
                        type=str,
                        default='barman-incr',
                        help='name of proccess to apply porto limit')

    parser.add_argument('--container_name',
                        type=str,
                        default='barman',
                        help='name of porto container')

    parser.add_argument('--comm_name',
                        type=str,
                        default='python',
                        help='process comm name /proc/<pid>/comm')
    return parser.parse_args()


def main():
    args = parse_args()
    if not get_pids(args.process_name):
        sys.exit(0)
    porto_conn = get_porto_connection()
    container_name = args.container_name
    try:
        container = porto_conn.Find('self/' + container_name)
    except porto.exceptions.ContainerDoesNotExist:
        container = porto_conn.Create('self/' + container_name)

    if container:
        if container.GetData('state') == 'stopped':
            container.SetProperty('isolate', False)
        container.SetProperty('cpu_limit', args.cpu_limit)
        container.SetProperty('io_limit', args.io_limit)
        if container.GetData('state') == 'stopped':
            container.Start()

    for pid in get_pids(args.process_name):
        try:
            porto_conn.AttachProcess(
                'self/' + container_name, int(pid), args.comm_name)
        except porto.exceptions.PermissionError:
            pass  # PID is already in the subcontainer
    try:
        if container.GetProperty('process_count') == '0':
            container.Destroy()
    except porto.exceptions.ContainerDoesNotExist:
        pass


if __name__ == '__main__':
    main()
