#!/usr/bin/python -u
# -*- coding: utf-8 -*-
import sys

TSKV_OUTPUT = (
    '%(x)s;%(y)s;%(z)s;tskv\ttskv_format=ydisk-pgsync-log-{0}\t'
    'timestamp=%(date)s %(time)s\ttimezone=+0300\t'
    'severity=%(severity)s\tmessage=%(message)s'
).format(sys.argv[1])


while True:
    try:
        line = sys.stdin.readline()
        if not line:
            break

        x, y, z, line = line.split(';', 3)
        date, time, text = line.split(' ', 2)
        severity, message = text.split(':\t', 1)
        message = message.strip().replace('\t', '\\t')
        print(TSKV_OUTPUT % dict(x=x, y=y, z=z, date=date, time=time, severity=severity, message=message))
    except Exception:
        continue
