#!/bin/bash

set -e

for dbname in postgres {{ salt['pillar.get']('data:dbname', '') }} template1; do
	echo "DROP EXTENSION IF EXISTS pg_stat_kcache;" | su - postgres -c "psql -P pager=off -q --no-align --tuples-only --no-readline $dbname"
done

service pgsync stop && service pgbouncer stop && service postgresql stop
{% if salt['pillar.get']('data:separate_array_for_xlogs', False) %}
mkdir -p /mnt/tmp
mv /var/lib/postgresql/9.6/data/pg_xlog/* /mnt/tmp/
umount /var/lib/postgresql/9.6/data/pg_xlog
mv /mnt/tmp/* /var/lib/postgresql/9.6/data/pg_xlog/
{% endif %}
{% if salt['pillar.get']('data:separate_array_for_data', True) %}
mkdir -p /var/lib/postgresql/9.6/data/9.6/data
shopt -s extglob
cd /var/lib/postgresql/9.6/data
mv !(9.6) /var/lib/postgresql/9.6/data/9.6/data/
shopt -u extglob
mv -n /var/lib/postgresql/.* /var/lib/postgresql/9.6/data/
cd /
umount /var/lib/postgresql/9.6/data/
mount /dev/md2 /var/lib/postgresql
chown postgres:postgres /var/lib/postgresql/9.6 /var/lib/postgresql/9.6/data
chmod 0700 /var/lib/postgresql/9.6/data
{% endif %}

apt-get -q -y -o DPkg::Options::=--force-confold -o DPkg::Options::=--force-confdef install \
	postgresql-10=10.10-103-yandex.44396.2fbecb6 \
	postgresql-10-smlar \
	postgresql-10-replmon=1.0.1-26 \
	libpq5=10.10-103-yandex.44396.2fbecb6 \
	postgresql-10-jsquery \
	postgresql-10-dbg=10.10-103-yandex.44396.2fbecb6 \
	postgresql-client-10=10.10-103-yandex.44396.2fbecb6 \
	postgresql-10-kcache=2.0.3-7130f1f \
	postgresql-10-repack=1.4.4-1.pgdg14.04+1+yandex0

rm -rf /var/lib/postgresql/10/data && sudo -u postgres /usr/lib/postgresql/10/bin/initdb -k --encoding=UTF8 --locale=en_US.UTF-8 --lc-collate=C --lc-ctype=C -D /var/lib/postgresql/10/data --auth-local peer --auth-host md5

service postgresql stop

mkdir -p /var/lib/postgresql/10/data/conf.d/ && cp /var/lib/postgresql/9.6/data/conf.d/pg_hba.conf /var/lib/postgresql/10/data/conf.d/pg_hba.conf
mkdir -p /etc/postgresql/10/data

cat > /etc/postgresql/10/data/postgresql.conf <<CONFEOF
hba_file = '/var/lib/postgresql/10/data/conf.d/pg_hba.conf'
data_directory = '/var/lib/postgresql/10/data'
CONFEOF

cd /var/lib/postgresql
sudo -u postgres /usr/lib/postgresql/10/bin/pg_upgrade -d /var/lib/postgresql/9.6/data/ -D /var/lib/postgresql/10/data/ -b /usr/lib/postgresql/9.6/bin -B /usr/lib/postgresql/10/bin -k -O "-c config_file=/etc/postgresql/10/data/postgresql.conf" -o "-c config_file=/etc/postgresql/9.6/data/postgresql.conf"
service postgresql start 10 || true
sudo -u postgres ./analyze_new_cluster.sh
sudo -u postgres ./delete_old_cluster.sh
rm -rf /etc/postgresql/9.6
service postgresql stop

{% if salt['pillar.get']('data:separate_array_for_data', True) %}
cd /
mkdir -p /tmp/pghome
mv -n /var/lib/postgresql/.* /tmp/pghome/
mv /var/lib/postgresql/10/data/* /var/lib/postgresql/
rm -rf /var/lib/postgresql/10
lsof /var/lib/postgresql/ | grep -v -e bash -e PID | awk '{print $2}' | xargs -I{} kill {}
umount /var/lib/postgresql
mv -n /tmp/pghome/.* /var/lib/postgresql/
mkdir -p /var/lib/postgresql/10/data
chown postgres:postgres /var/lib/postgresql/10 /var/lib/postgresql/10/data
chmod 0700 /var/lib/postgresql/10/data
mount /dev/md2 /var/lib/postgresql/10/data/
{% endif %}
{% if salt['pillar.get']('data:separate_array_for_xlogs', False) %}
mkdir -p /mnt/tmp && mount /dev/md3 /mnt/tmp && mv -v /var/lib/postgresql/10/data/pg_wal/* /mnt/tmp && umount /mnt/tmp
mount /dev/md3 /var/lib/postgresql/10/data/pg_wal
chown postgres:postgres /var/lib/postgresql/10/data/pg_wal
{% endif %}

salt-call state.highstate pillar='{"data": {"pg": {"version": {"major_num":1000}}}}'

for dbname in postgres {{ salt['pillar.get']('data:dbname', '') }} template1; do
	echo "CREATE EXTENSION pg_stat_kcache;" | su - postgres -c "psql -P pager=off -q --no-align --tuples-only --no-readline $dbname" || true
done
