#!/bin/sh

# Required two parameters:
# 1 - required xlog name (usually %f macros)
# 2 - full name of target xlog (usually %p macros)
unpack_dir="/dev/shm/xlog_unpack"

if [ -z "${1}" ] || [ -z "${2}" ]; then
    echo "Required two parameters"
    exit 1
fi

if [ -f "${2}" ]; then
    echo "Target WAL ${2} already exists."
    exit 1
fi

if [ ! -d $unpack_dir ]; then
    mkdir $unpack_dir
fi

backup_server="{{ barman }}"
rsync_options="-a --contimeout=1 --timeout=5 --password-file=/etc/barman.passwd"
suffix=`hostname -s | grep -Eo '[a-z0-9-]+[0-9]+'`

dir=`echo ${1} | grep -Eo '^[0-9A-F]{16}'`
rsync ${rsync_options} rsync://barman@${backup_server}:/barman/${suffix}/wals/$dir/${1} $unpack_dir/${1}

file_type=$(hexdump "$unpack_dir/${1}" | head -c 17 2>&1)

if [ "$file_type" == "0000000 8b1f 0008" -o "$file_type" == "0000000 8b1f 0808" ]; then
    gzip -dc $unpack_dir/${1} > ${2}
    rm -f $unpack_dir/${1}
else
    mv $unpack_dir/${1} ${2}
fi

if [ ${?} -eq 0 ]; then
    exit 0
fi

exit 1
