{% from "components/postgres/pg.jinja" import pg with context %}
{% if salt['grains.get']('os') == 'Ubuntu' %}
{% if salt['pillar.get']('data:config:log_rotate_by_size', False) %}
/etc/cron.d/logrotate_by_size:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/cron.d/logrotate_by_size
        - mode: 644

{% endif %}
/etc/logrotate.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/logrotate.conf
        - mode: 644

/etc/cron.daily/logrotate:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/logrotate.daily
        - mode: 755
{% endif %}

/etc/logrotate.d/postgresql-common:
    file.managed:
        - source: salt://{{ slspath }}/conf/postgresql.logrotate
        - template: jinja
        - mode: 644
        - user: root
        - group: root

/etc/security/limits.d/80-postgres.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/limits.conf
        - mode: 644
        - user: root
        - group: root
        - makedirs: True

/etc/sudoers.d/postgres:
    file.absent

hack_sudoers:
    file.append:
        - name: /etc/sudoers
        - text: '#includedir /etc/sudoers.d'

/etc/atop/atop.daily:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/atop.daily
        - mode: 711
        - user: root
        - group: root
        - makedirs: True

{{ pg.prefix }}/.bashrc:
    file.managed:
        - source: salt://{{ slspath }}/conf/bashrc
        - template: jinja
        - user: postgres
        - group: postgres
        - mode: 744

{{ pg.prefix }}/.role.sh:
    file.managed:
        - source: salt://{{ slspath }}/conf/role.sh
        - user: postgres
        - group: postgres
        - mode: 744

{% if salt['grains.get']('os') != 'Ubuntu' %}
{{ pg.prefix }}/.bash_profile:
    file.append:
        - text: '[ -f .bashrc ] && source .bashrc'
{% endif %}

{% if salt['grains.get']('os') == 'Ubuntu' %}
/etc/init.d/postgresql-pre:
    file.managed:
        - source: salt://{{ slspath }}/conf/postgresql-pre.init.ubuntu
        - mode: 755
        - template: jinja
        - mode: 755
        - require:
            - file: {{ pg.data }}/conf.d/postgresql.conf
    cmd.wait:
        - name: update-rc.d postgresql-pre defaults 16 && /etc/init.d/postgresql-pre start
        - watch:
            - file: /etc/init.d/postgresql-pre
        - require_in:
            - service: postgresql-service
{% endif %}

/root/.bashrc:
    file.managed:
        - source: salt://{{ slspath }}/conf/bashrc_root
        - template: jinja
        - user: root
        - group: root
        - mode: 644
{% if salt['grains.get']('os') == 'Ubuntu' %}
        - unless:
            - grep 'export PATH.*{{ pg.bin_path }}' /root/.bashrc
{% endif %}

{{ pg.prefix }}/.psqlrc:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/psqlrc
        - user: postgres
        - group: postgres
        - mode: 744

/root/.pgpass:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/common-pgpass
        - user: root
        - group: root
        - mode: 600

/home/monitor/.pgpass:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/pgpass
        - user: monitor
        - group: monitor
        - mode: 600

{{ pg.prefix }}/.pgpass:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/common-pgpass
        - user: postgres
        - group: postgres
        - mode: 600

{{ pg.prefix }}/.psql_history-postgres:
    file.managed:
        - user: postgres
        - group: postgres
        - mode: '0600'
        - replace: False

{{ pg.prefix }}/.ssh/authorized_keys:
    file.copy:
        - source: /root/.ssh/authorized_keys
        - user: postgres
        - group: postgres
        - mode: 600
        - force: True
        - require:
            - file: {{ pg.prefix }}/.ssh
        - unless:
            - diff -I robot-pgbarman /root/.ssh/authorized_keys {{ pg.prefix }}/.ssh/authorized_keys

{% if salt['grains.get']('os') == 'Ubuntu' %}
/etc/rc.local:
{% else %}
/etc/rc.d/rc.local:
{% endif %}
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/rc.local
        - user: root
        - group: root
        - mode: 755

/usr/local/bin/raid-check-last-dt.sh:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/raid-check-last-dt.sh
        - user: root
        - group: root
        - mode: 755

/usr/local/bin/raid-check-disable.sh:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/raid-check-disable.sh
        - user: root
        - group: root
        - mode: 755

/etc/pgswitch.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/pgswitch.conf
        - mode: 600
        - require:
            - pkg: yamail-pgswitch

/etc/security/local.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/security-local.conf
        - mode: 600

/usr/local/yandex/pg_wait_started.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/pg_wait_started.py
        - user: postgres
        - group: postgres
        - mode: 755
        - require:
            - file: /usr/local/yandex

/usr/local/yandex/populate_recovery_conf.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/populate_recovery_conf.py
        - template: jinja
        - user: postgres
        - defaults:
            pg_prefix: {{ pg.data }}
        - group: postgres
        - mode: 755
        - require:
            - file: /usr/local/yandex

/etc/cron.yandex/clear_statements_stats.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/clear_statements_stats.py
        - user: postgres
        - group: postgres
        - mode: 755
        - require:
            - file: /etc/cron.yandex

{% if salt['grains.get']('os') == 'Ubuntu' and salt['grains.get']('virtual') == 'lxc'%}
python-portopy:
    pkg.installed:
        - version: 4.12.20
{% endif %}

{% if salt['grains.get']('os') != 'Ubuntu' and salt['grains.get']('virtual') == 'physical'%}
/etc/cron.d/raid-check:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/cron.d/raid-check
        - mode: 644

/etc/sysconfig/raid-check:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/raid-check
        - user: root
        - group: root
        - mode: 644
{% endif %}

{% set cron_jobs = [
                    'pg_auto_kill',
                    'pg_renice_pgbouncer',
                    'pg_statements_stats',
                    'pg_rm_old_archive_status',
                    'atop',
                    'yasm-tail-watchdog'
                   ]
%}

{% for job in cron_jobs %}
/etc/cron.d/{{ job }}:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/cron.d/{{ job }}
        - mode: 644
{% endfor %}

pg-common-configs-crond-reload:
    service.running:
        - name: {{ pg.cron_service }}
        - reload: True
        - watch:
{% for job in cron_jobs %}
            - file: /etc/cron.d/{{ job }}
{% endfor %}

{% if salt['grains.get']('os') == 'Ubuntu' %}
/etc/postgresql/{{ pg.version.major }}/data/pg_ident.conf:
    file.managed:
        - mode: 600
        - user: postgres
        - group: postgres
        - replace: False
        - require:
            - file: /etc/postgresql/{{ pg.version.major }}/data
        - require_in:
            - file: {{ pg.data }}/conf.d/postgresql.conf
            - service: postgresql-service

/etc/postgresql/{{ pg.version.major }}/data/environment:
    file.managed:
        - mode: 644
        - user: postgres
        - group: postgres
        - replace: False
        - require:
            - file: /etc/postgresql/{{ pg.version.major }}/data
        - require_in:
            - file: {{ pg.data }}/conf.d/postgresql.conf
            - service: postgresql-service

/etc/postgresql/{{ pg.version.major }}/data/postgresql.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/postgresql-include-only.conf
        - mode: 644
        - user: postgres
        - group: postgres
        - require:
            - file: /etc/postgresql/{{ pg.version.major }}/data
        - require_in:
            - file: {{ pg.data }}/conf.d/postgresql.conf
            - service: postgresql-service

/etc/postgresql/{{ pg.version.major }}/data/pg_ctl.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/pg_ctl.conf
        - mode: 644
        - user: postgres
        - group: postgres
        - require:
            - file: /etc/postgresql/{{ pg.version.major }}/data
        - require_in:
            - file: {{ pg.data }}/conf.d/postgresql.conf
            - service: postgresql-service

/etc/postgresql/{{ pg.version.major }}/data/start.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/start.conf
        - mode: 644
        - user: postgres
        - group: postgres
        - require:
            - file: /etc/postgresql/{{ pg.version.major }}/data
        - require_in:
            - file: {{ pg.data }}/conf.d/postgresql.conf
            - service: postgresql-service
{% endif %}

{{ pg.data }}/conf.d/postgresql.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/postgresql.conf
        - mode: 644
        - user: postgres
        - group: postgres

{{ pg.data }}/conf.d/pg_hba.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/pg_hba.conf
        - mode: 644
        - user: postgres
        - group: postgres

postgresql-reload:
    service.running:
        - name: {{ pg.service }}
        - reload: True
        - watch:
            - file: {{ pg.data }}/conf.d/postgresql.conf
            - file: {{ pg.data }}/conf.d/pg_hba.conf
        - require:
            - service: postgresql-service

{% if salt['pillar.get']('data:use_replication_slots', True) %}
/etc/cron.yandex/pg_recreate_unused_slot.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/pg_recreate_unused_slot.py
        - user: postgres
        - group: postgres
        - mode: 755
        - require:
            - file: /etc/cron.yandex
/etc/cron.d/pg_recreate_unused_slot:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/cron.d/pg_recreate_unused_slot
        - mode: 644
{% endif %}

{% for pg_set_script in ["pg_set_async", "pg_set_sync"] %}
/usr/local/sbin/{{ pg_set_script }}:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/{{ pg_set_script }}
        - mode: 755
        - user: root
        - group: root

{% endfor %}

/usr/local/sbin/pg_is_replication_sync.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/pg_is_replication_sync.py
        - user: root
        - group: root
        - mode: 755

/usr/local/sbin/upgrade_9_to_10.sh:
    file.managed:
        - source: salt://{{ slspath }}/conf/upgrade_9_to_10.sh
        - template: jinja
        - user: root
        - group: root
        - mode: 755

/etc/cron.yandex/yasm_tail_watchdog.sh:
    file.managed:
        - source: salt://{{ slspath }}/conf/yasm_tail_watchdog.sh
        - template: jinja
        - user: root
        - group: root
        - mode: 755
        - require:
            - file: /etc/cron.yandex
