{% from "components/postgres/pg.jinja" import pg with context %}

diagnostic-packages:
    pkg.installed:
        - pkgs:
{% if salt['grains.get']('os') == 'Ubuntu' %}
{% if salt['grains.get']('virtual', 'physical') != 'lxc' and salt['grains.get']('virtual_subtype', None) != 'Docker' %}
            - "linux-image-{{ salt['grains.get']('kernelrelease', '4.14.127-42') }}-dbgsym"
{% endif %}
            - libc6-dbg: '2.19-0ubuntu6.*'
            - gdb: 7.7.1-0ubuntu5~14.04.3
            - strace: 4.8-1ubuntu5
            - ltrace: 0.7.3-4ubuntu5.1
{% else %}
{% if salt['grains.get']('virtual', 'physical') != 'lxc' %}
            - kernel-debuginfo: 2.6.32-696.6.3.el6
{% endif %}
            - glibc-debuginfo: 2.12-1.209.el6
            - perf: 2.6.32-696.6.3.el6
            - gdb: 7.2-83.el6
            - strace: 4.8-10.el6
            - ltrace: 0.5-28.45svn.el6
{% endif %}

/usr/local/yandex/gdb_bt_cmd:
    file.managed:
        - source: salt://{{ slspath }}/conf/gdb_bt_cmd
        - user: root
        - group: root
        - mode: 644
        - makedirs: True
        - require:
            - pkg: diagnostic-packages

/usr/bin/bt:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/bt.py
        - user: root
        - group: root
        - mode: 755
        - require:
            - pkg: diagnostic-packages
            - file: /usr/local/yandex/gdb_bt_cmd
            - service: postgresql-service

diagnosctic-sqls-dir:
    file.directory:
        - name: {{ pg.prefix }}/.sql
        - makedirs: True
        - user: postgres
        - group: postgres
        - mode: 755

diagnostics-sqls:
    file.recurse:
        - name: {{ pg.prefix }}/.sql
        - file_mode: '0755'
        - template: jinja
        - source: salt://{{ slspath }}/conf/sql
        - include_empty: True
        - require:
            - file: diagnosctic-sqls-dir
