{% from "components/postgres/pg.jinja" import pg with context %}

{% set mandatory_extensions = ['pg_stat_statements'] %}

{% if pg.version.major_num < 906 %}
{% do mandatory_extensions.append('pgespresso') %}
{% endif %}

{% set extensions = salt['pillar.get']('data:config:shared_preload_libraries', '').split(',') %}
{% for i in mandatory_extensions %}
{% if i not in extensions %}
{% do extensions.insert(0, i) %}
{% endif %}
{% endfor %}
{% for i in ['repl_mon', 'auto_explain', 'pg_pathman'] %}
{% if i in extensions %}
{% do extensions.remove(i) %}
{% endif %}
{% endfor %}
{% for extension in extensions %}
{% if extension %}
{% for db in ['template1', 'postgres'] %}
pg-extension-{{ extension }}-{{ db }}:
    postgresql_cmd.psql_exec:
        - name: 'create extension {{ extension }}'
        - maintenance_db: {{ db }}
        - require:
            - cmd: postgresql-service
        - unless:
            - -c "select extname from pg_catalog.pg_extension;" | grep {{ extension }}
{% endfor %}
{% endif %}
{% endfor %}

{% if 'pg_stat_wait' in salt['pillar.get']('data:config:shared_preload_libraries', '') %}
{% if salt['grains.get']('pg:role', 'master') == 'master' %}
pg_stat_wait_profile-monitor-permission:
    postgresql_cmd.psql_exec:
        - name: grant select on pg_stat_wait_profile to monitor
        - unless:
            - -tA -c "select has_table_privilege('monitor', 'public.pg_stat_wait_profile', 'select');" | grep -q "^t"
        - require:
            - cmd: postgresql-service
            - cmd: pg-extension-pg_stat_wait-postgres
            - postgres_user: postgres-user-monitor
{% endif %}
{% endif %}
