include:
    - .pgbouncer

{% if salt['grains.get']('os') == 'Ubuntu' %}
    {% set supervisor_version = '3.3.1-1yandex' %}
{% else %}
    {% set supervisor_version = '3.3.0-3' %}
{% endif %}

supervisor:
    pkg:
        - installed
        - version: {{ supervisor_version }}
    service:
        - running
        - enable: True
        - require:
            - pkg: supervisor

stop_pgbouncer:
    cmd.run:
        - name: kill $(ps aux | grep pgbouncer | grep -v grep | awk '{print $2};') || true
        - runas: root
        - require:
            - pkg: supervisor
            - pkg: pgbouncer
        - unless: grep supervisor /etc/init.d/pgbouncer

{% if salt['grains.get']('os') != 'Ubuntu' %}
/etc/sysconfig/supervisord:
    file.managed:
        - template: jinja
        - makedirs: True
        - source: salt://{{ slspath }}/conf/supervisor.sysconfig
        - require_in:
            - cmd: stop_pgbouncer
            - service: pgbouncer
{% endif %}

supervisor-config-restart:
    cmd.wait:
        - name: (supervisorctl restart prestart_pgbouncer && supervisorctl reread && supervisorctl update) || true
        - require_in:
            - service: pgbouncer
        - watch:
            - file: /etc/supervisor/supervisord.conf 
            - file: /etc/supervisor/conf.d/*

/var/log/supervisor:
    file.directory:
        - makedirs: True
        - require_in:
            - cmd: stop_pgbouncer
            - service: pgbouncer

/etc/supervisor/supervisord.conf:
    file.managed:
        - template: jinja
        - makedirs: True
        - source: salt://{{ slspath }}/conf/supervisor.conf
        - require_in:
            - service: pgbouncer
            - cmd: stop_pgbouncer

/etc/supervisor/conf.d/pgbouncer.conf:
    file.managed:
        - template: jinja
        - makedirs: True
        - source: salt://{{ slspath }}/conf/pgbouncer.conf
        - require:
            - file: /usr/local/bin/prestart_pgbouncer.sh
        - require_in:
            - service: pgbouncer
            - cmd: stop_pgbouncer

/etc/init.d/pgbouncer:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/pgbouncer_supervisor.init
        - follow_symlinks: False
        - mode: 755
        - require:
            - pkg: supervisor
            - cmd: stop_pgbouncer
        - require_in:
            - service: pgbouncer

/usr/local/bin/prestart_pgbouncer.sh:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/prestart_pgbouncer.sh
        - mode: 0755
        - require_in:
            - service: pgbouncer
            - file: /etc/supervisor/conf.d/pgbouncer.conf

/etc/cron.d/wd-habouncer:
    file.managed:
        - source: salt://{{ slspath }}/conf/cron.d/wd-habouncer
        - require:
            - service: pgbouncer

{% for c in range(salt['pillar.get']('data:pgbouncer:count')) %}
{% set bouncer_count="%02d"|format(c|int) %}
/etc/pgbouncer/pgbouncer{{ bouncer_count }}.ini:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/pgbouncer.ini
        - defaults:
            bouncer: {{ bouncer_count }}
        - require_in:
            - service: pgbouncer
            - service: supervisor-config-restart

pgbouncer{{ bouncer_count }}-reload:
    cmd.wait:
        - name: pid=$(supervisorctl pid pgbouncer_external:pgbouncer_external{{ bouncer_count }}); if [ "$pid" != "0" ]; then echo "Reloading $pid"; kill -HUP "$pid"; fi
        - watch:
            - file: /etc/pgbouncer/pgbouncer{{ bouncer_count }}.ini
        - require:
            - service: pgbouncer
            - cmd: supervisor-config-restart
{% endfor %}

{% for c in range(salt['pillar.get']('data:pgbouncer:internal_count', 1)) %}
{% set bouncer_count="%02d"|format(c|int) %}
/etc/pgbouncer/pgbouncer_internal{{ bouncer_count }}.ini:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/pgbouncer.ini
        - defaults:
            internal_bouncer: {{ bouncer_count }}
        - require_in:
            - service: pgbouncer
            - service: supervisor-config-restart
        - watch_in:
            - service: supervisor-config-restart

pgbouncer_internal{{ bouncer_count }}-reload:
    cmd.wait:
{% if salt['pillar.get']('data:unmanaged_dbs', {}) %}
        - name: supervisorctl restart pgbouncer_internal{{ bouncer_count }}
{% else %}
        - name: pid=$(supervisorctl pid pgbouncer_internal:pgbouncer_internal{{ bouncer_count }}); if [ "$pid" != "0" ]; then echo "Reloading $pid"; kill -HUP "$pid"; fi
{% endif %}
        - watch:
            - file: /etc/pgbouncer/pgbouncer_internal{{ bouncer_count }}.ini
        - require:
            - service: pgbouncer
            - cmd: supervisor-config-restart
{% endfor %}
