{% from "components/postgres/pg.jinja" import pg with context %}
include:
    - components.common.dirs
    - components.graphite.pg
    - components.monrun2.pg-common
    - components.abyssync
    - .pkgs
    - .groups
    - .directories
    - .configs
{% if salt['grains.get']('os') == 'Ubuntu' and salt['grains.get']('virtual') == 'lxc' and salt['grains.get']('osrelease') == '14.04' %}
    - components.repositories.apt.search-trusty.stable
    - components.repositories.apt.search-trusty.unstable
{% endif %}
    - .sysctl
{% if pg.connection_pooler == 'pgbouncer' %}
{% if salt['pillar.get']('data:pgbouncer:count', 1) > 1 %}
    - .habouncer
{% else %}
    - .pgbouncer
{% endif %}
{% endif %}
{% if salt['grains.get']('os') == 'Ubuntu' %}
    - .pkgs_ubuntu
{% else %}
    - .pkgs_rhel
{% endif %}
{% if pg.is_replica %}
    - .replica
{% else %}
    - .master
    - .extensions
    - .users
{% endif %}
    - .service
{% if salt['pillar.get']('service-restart', False) %}
    - .restart
{% endif %}
    - .yasmagent
{% if salt['pillar.get']('data:diagnostic_tools', True) %}
    - .diagnostics
{% endif %}
{% if salt['pillar.get']('data:separate_array_for_xlogs', False) %}
#     - .xlogs
{% endif %}
{% if salt['pillar.get']('data:use_pgsync', False) %}
    - .pgsync
{% endif %}
{% if salt['pillar.get']('data:separate_array_for_sata', False) %}
    - .sata
{% endif %}
    - .sqls
{% if salt['pillar.get']('data:fastbone', False) and salt['grains.get']('os') != 'Ubuntu' %}
    - .fastbone
{% endif %}
{% if salt['pillar.get']('data:use_pg_partman', False) %}
    - .pg_partman
{% endif %}
{% if salt['pillar.get']('data:use_postgis', False) %}
    - .postgis
{% endif %}
{% if salt['pillar.get']('data:pg-classify', {}) and not salt['grains.get']('virtual', 'physical') == 'lxc' %}
    - .classify
{% endif %}
{% if salt['pillar.get']('data:do_index_repack', False) or salt['pillar.get']('data:do_table_repack', False) and salt['pillar.get']('data:cgroup:groups:index_repack', {}) %}
    - .repack
{% endif %}
{% if salt['pillar.get']('data:pg_ssl', True) %}
    - .ssl
{% endif %}
    - components.pgsampler
{% if salt['grains.get']('virtual', 'physical') != 'lxc' %}
    - components.cgroup
{% endif %}
{% if salt['grains.get']('os') == 'Ubuntu' and salt['pillar.get']('data:mdb_metrics:enabled', True) %}
    - components.mdb-metrics
    - .postgres-metrics-disabled
{% elif salt['pillar.get']('data:use_postgres_metrics', True) %}
    - .postgres-metrics
{% endif %}
{% if salt['pillar.get']('data:use_walg', False) %}
    - .walg
{% endif %}
{% if salt['pillar.get']('data:use_wale', False) %}
    - .wale
{% endif %}
{% if salt['pillar.get']('data:ship_logs', False) %}
    - components.push-client
    - .pushclient
{% endif %}
{% if not pg.is_replica %}
    - .add_to_sharpei
{% endif %}
