{% from "components/postgres/pg.jinja" import pg with context %}

include:
    - components.common.locale

pg-init:
    postgresql_cmd.master_init:
        - name: {{ pg.data }}
        - version: {{ pg.version.major }}
        - require:
            - pkg: postgresql{{ pg.version.short }}-server
        - require_in:
            - file: /etc/postgresql/{{ pg.version.major }}/data
            - service: postgresql-service

{{ pg.data }}/conf.d:
    file.directory:
        - user: postgres
        - group: postgres
        - mode: 755
        - require:
            - pkg: postgresql{{ pg.version.short }}-server
        - require_in:
            - file: {{ pg.data }}/conf.d/postgresql.conf
            - file: {{ pg.data }}/conf.d/pg_hba.conf

{% if salt['pillar.get']('restore-from:cid') %}{# RESTORE-FROM #}

/tmp/recovery-state:
    file.directory:
        - user: postgres
        - group: postgres
        - mode: 0750
        - makedirs: True

restore-from-pillar-valid:
    test.check_pillar:
        - dictionary:
            - restore-from:rename-database-from-to
        - integer:
            - restore-from:source-cluster-options:max_connections
        - string:
            - restore-from:time

{{ pg.data }}/recovery.conf:
    file.managed:
        - user: postgres
        - group: postgres
        - contents: |
            recovery_target_action = 'promote'
            restore_command = '/usr/bin/envdir /etc/wal-g/envdir-for-restore /usr/bin/wal-g wal-fetch "%f" "%p"'
            recovery_target_time = '{{ salt['pillar.get']('restore-from:time') }}'
            recovery_target_inclusive = {{ {True: 'true', False: 'false'}[salt['pillar.get']('restore-from:time-inclusive')] }}
        - require:
             - cmd: backup-fetched

/usr/local/yandex/pg_restore_from_backup.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/pg_restore_from_backup.py
        - user: postgres
        - group: postgres
        - mode: 755
        - require:
            - file: /usr/local/yandex

postgresql-restore:
    cmd.run:
        - name: >
            python /usr/local/yandex/pg_restore_from_backup.py
            --recovery-state=/tmp/recovery-state
            --pg-bin={{ pg.bin_path }}
            --pg-data={{ pg.data }}
            --pg-config={{ pg.config_file_path }}
            --rename-databases-from-to='{{ salt['pillar.get']('restore-from:rename-database-from-to') | json }}'
            --source-max-connections={{ salt['pillar.get']('restore-from:source-cluster-options:max_connections') }}
        - runas: postgres
        - require:
            - file: /usr/local/yandex/pg_restore_from_backup.py
            - pkg: python-psycopg2
            - file: /tmp/recovery-state
            - test: restore-from-pillar-valid
            - file: {{ pg.data }}/conf.d/postgresql.conf
            - file: {{ pg.data }}/conf.d/pg_hba.conf
            - file: {{ pg.data }}/recovery.conf
            - file: /var/log/postgresql
            - cmd: /etc/sysctl.d/postgres.conf
            - cmd: backup-fetched
            - cmd: locale-gen
        - require_in:
            - service: postgresql-service
{% endif %}


{% if salt['pillar.get']('data:dbaas:shard_hosts') %}
{%     set req_repl_slots = [] %}
{%     for shard_host in salt['pillar.get']('data:dbaas:shard_hosts') %}
{%         do req_repl_slots.append(shard_host.replace('.', '_').replace('-', '_')) %}
{%     endfor %}
{%     for slot in salt['grains.get']('pg:replication_slots', []) %}
{%         if slot not in req_repl_slots %}
drop_replication_slot_{{ slot }}:
    postgresql_cmd.psql_exec:
        - name: SELECT pg_drop_replication_slot('{{ slot }}')
        - require:
            - cmd: postgresql-service
{%         endif %}
{%     endfor %}
{% endif%}
