{% from "components/postgres/pg.jinja" import pg with context %}

include:
    - components.common.dirs

pg_partman:
    pkg.installed:
        - name: postgresql-{{ pg.version.major }}-partman
        - version: 3.1.3-1.pgdg14.04+1

/etc/cron.yandex/pg_partman_maintenance.py:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/pg_partman_maintenance.py
        - mode: 755
        - user: postgres
        - require:
            - file: /etc/cron.yandex

/etc/cron.d/pg_partman:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/cron.d/pg_partman
        - mode: 644
        - require:
            - file: /etc/cron.yandex/pg_partman_maintenance.py
    service.running:
        - name: {{ pg.cron_service }}
        - reload: True
        - watch:
            - file: /etc/cron.d/pg_partman
