include:
    - .pgbouncer-configs

{% from "components/postgres/pg.jinja" import pg with context %}
{% if salt['grains.get']('os') == 'Ubuntu' %}
    {% if pg.version.major_num >= 1000 %}
        {% set pgbouncer_version = '1007-a122af8' %}
    {% else %}
        {% set pgbouncer_version = '1.8.1-2yandex38' %}
    {% endif %}
{% else %}
    {% set pgbouncer_version = '1.7.2-3yandex25' %}
{% endif %}

/var/log/postgresql/pgbouncer.log:
    file.managed:
        - user: postgres
        - group: postgres
        - replace: False
        - require:
            - pkg: pgbouncer
        - require_in:
            - service: pgbouncer

pgbouncer-pkg:
    pkg.installed:
        - name: pgbouncer
        - version: {{ pgbouncer_version }}
{% if salt['pillar.get']('data:pgbouncer:count', 1) > 1 %}
        - require:
            - service: supervisor
{% endif %}
        - require_in:
           - file: /etc/pgbouncer/pgbouncer.ini
           - file: /etc/pgbouncer/userlist.txt

pgbouncer:
{% if salt['pillar.get']('data:use_pgsync', True) %}
    service.disabled:
{% else %}
    service.running:
        - enable: True
{% endif %}
        - require:
            - pkg: pgbouncer-pkg
            - file: /etc/pgbouncer/pgbouncer.ini
            - file: /etc/pgbouncer/userlist.txt
            - file: /etc/security/limits.d/99-pgbouncer.conf
            - file: /etc/default/pgbouncer

/etc/default/pgbouncer:
    file.managed:
        - source: salt://{{ slspath }}/conf/pgbouncer-default-ubuntu

{% if salt['pillar.get']('data:diagnostic_tools', True) and salt['grains.get']('os') != 'Ubuntu'%}
pgbouncer-debuginfo:
    pkg.purged
{% endif %}

{% if salt['pillar.get']('data:unmanaged_dbs', {}) %}
pgbouncer-restart:
    cmd.wait:
        - name: service pgbouncer stop; service pgbouncer start || true
        - watch:
            - file: /etc/pgbouncer/pgbouncer.ini
        - require:
            - service: pgbouncer
{% else %}
{% if salt['pillar.get']('data:pgbouncer:count', 1)==1 %}
pgbouncer-reload:
    cmd.wait:
        - name: service pgbouncer reload
        - require:
            - service: pgbouncer
        - watch:
            - file: /etc/pgbouncer/pgbouncer.ini
{% endif %}
{% endif %}

{% if salt['pillar.get']('data:pgbouncer:count', 1)==1 %}
/etc/init.d/pgbouncer:
    file.managed:
        - source: salt://{{ slspath }}/conf/pgbouncer.init.ubuntu
        - mode: 755
        - user: root
        - group: root
        - require:
            - pkg: pgbouncer
        - require_in:
            - service: pgbouncer
{% endif %}
