{% from "components/postgres/pg.jinja" import pg with context %}

yamail-pgsync:
    pkg.installed:
        - pkgs:
{% if salt['pillar.get']('yandex:environment', 'dev') == 'prod' %}
            - yamail-pgsync: 349-1a1352d
{% else %}
            - yamail-pgsync: 360-f1dadb8
{% endif %}
{% if salt['grains.get']('os') != 'Ubuntu' %}
            - python-lockfile: "0:0.12.2-1.el6"
{% elif salt['grains.get']('os') == 'Ubuntu' %}
            - python-daemon: 2.0.5-2yandex6
            - python-lockfile: "1:0.10.2-3yandex5"
            - python-kazoo: 2.5.0-2yandex
{% endif %}

/etc/pgsync.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/pgsync.conf
        - mode: 644
        - user: root
        - group: root
        - require:
            - pkg: yamail-pgsync

/var/log/pgsync:
    file.directory:
        - user: postgres
        - group: postgres

/var/run/pgsync:
    file.directory:
        - user: postgres
        - group: postgres

{% if salt['pillar.get']('restore-from:cid') %}
init-pgsync-for-restored-cluster:
    cmd.run:
        - name: pgsync-util initzk {{ salt['grains.get']('fqdn')  }}
        - require:
            - service: postgresql-service
        - require_in:
            - service: pgsync
{% endif %}

pgsync:
    service.running:
        - enable: True
        - require:
            - service: postgresql-service
            - file: /var/log/pgsync
            - file: /var/run/pgsync
            - file: /etc/pgsync.conf
        - watch:
            - file: /etc/pgsync.conf
            - pkg: yamail-pgsync

/etc/cron.d/wd-pgsync:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/cron.d/wd-pgsync
        - mode: 644

{% if salt['pillar.get']('data:auto_resetup', False) %}
/etc/cron.yandex/pg_resetup.py:
    file.managed:
        - template: jinja
        - mode: 755
        - source: salt://{{ slspath }}/conf/pg_resetup.py

/etc/cron.d/pg_resetup:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/cron.d/pg_resetup
        - mode: 644
{% endif %}

{% if salt['pillar.get']('data:pgsync:plugins:upload_wals', True) %}
/etc/pgsync/plugins/upload_wals.py:
    file.symlink:
        - target: /opt/yandex/pgsync/lib/python3.6/site-packages/pgsync/plugins/upload_wals.py
        - require:
            - pkg: yamail-pgsync
        - require_in:
            - service: pgsync
{% endif %}
