{% from "components/postgres/pg.jinja" import pg with context %}

include:
  - components.repositories.yum.pgdg-redhat{{ pg.version.short }}

{% if pg.version.major_num == 904 %}
{% set pg_version = salt['pillar.get']('data:pg:version:pkg', '9.4.6-1yandex.37746.8b63d50') + '.el6' %}
{% set pgespresso_version = '1.0.0-2.rhel6' %}
{% set kcache_version = '2.0.3-1.rhel6' %}
{% set pg_top_version = '3.7.0-3.rhel6' %}
{% elif pg.version.major_num == 905 %}
{% set pg_version = salt['pillar.get']('data:pg:version:pkg', '9.5.5-1yandex.39697.5eb6896') + '.el6' %}
{% set pgespresso_version = '1.0-1.el6' %}
{% set kcache_version = '2.0.3-7fffadd' %}
{% set pg_top_version = '3.7.0-3.rhel6' %}
{% elif pg.version.major_num == 906 %}
{% set pg_version = salt['pillar.get']('data:pg:version:pkg', '9.6.7-1yandex.41621.7991071') + '.el6' %}
{% set kcache_version = '2.0.3-7130f1f' %}
{% set pg_top_version = '3.7.0-5.rhel6' %}
{% endif %}

postgresql{{ pg.version.short }}-server:
    pkg.installed:
        - pkgs:
            - postgresql{{ pg.version.short }}: {{ pg_version }}
            - postgresql{{ pg.version.short }}-libs: {{ pg_version }}
            - postgresql{{ pg.version.short }}-server: {{ pg_version }}
            - postgresql{{ pg.version.short }}-contrib: {{ pg_version }}
            - pg_top{{ pg.version.short }}: {{ pg_top_version }}
{% if pg.version.major_num < 906 %}
            - pgespresso{{ pg.version.short }}: {{ pgespresso_version }}
{% endif %}
        - require:
            - pkgrepo: pgdg-redhat
        - order: 2

{% if salt['pillar.get']('data:diagnostic_tools', True) %}
pg_stat_kcache{{ pg.version.short }}:
    pkg.installed:
        - version: {{ kcache_version }}
        - require_in:
            - service: postgresql-service
{% endif %}
