{% from "components/postgres/pg.jinja" import pg with context %}

{% if pg.version.major_num == 906 %}
{% set pg_version = salt['pillar.get']('data:pg:version:pkg', '9.6.9-1yandex.41743.1545ca9') %}
{% set kcache_version = '2.0.3-7130f1f' %}
{% elif pg.version.major_num == 1000 %}
{% set pg_version = salt['pillar.get']('data:pg:version:pkg', '10.13-106-yandex.44724.a411361705') %}
{% set kcache_version = '2.0.3-7130f1f' %}
{% elif pg.version.major_num == 1100 %}
{% set pg_version = salt['pillar.get']('data:pg:version:pkg', '11.8-106-yandex.46473.d439e27d5f') %}
{% set kcache_version = '2.1.1-2.pgdg14.04+1' %}
{% endif %}

{% if salt['grains.get']('oscodename') == 'trusty' %}
{% set pgtop_version = '3.7.0-2.pgdg14.04+1' %}
{% elif salt['grains.get']('oscodename') == 'bionic' %}
{% set pgtop_version = 'latest' %}
{% endif %}

postgresql-common-pkg:
    pkg.installed:
        - name: postgresql-common
    file.managed:
        - name: /etc/postgresql-common/createcluster.conf
        - require:
            - pkg: postgresql-common-pkg
        - require_in:
            - pkg: postgresql{{ pg.version.short }}-server
        - template: jinja
        - source: salt://{{ slspath + '/conf/createcluster.conf' }}

postgresql{{ pg.version.short }}-server:
    pkg.installed:
        - pkgs:
            - libpq5: {{ pg_version }}
            - postgresql-{{ pg.version.major }}: {{ pg_version }}
            - postgresql-client-{{ pg.version.major }}: {{ pg_version }}
            - postgresql-{{ pg.version.major }}-dbg: {{ pg_version }}
            - postgresql-{{ pg.version.major }}-smlar
{% if pg.version.major_num < 1000 %}
            - postgresql-contrib-{{ pg.version.major }}: {{ pg_version }}
{% else %}
            - postgresql-{{ pg.version.major }}-replmon: 1.0.1-26
            - postgresql-{{ pg.version.major }}-jsquery
{% endif %}
        - refresh: True

pgtop:
    pkg.installed:
        - version: {{ pgtop_version }}
        - require_in:
            - service: postgresql-service

{% if pg.version.major_num < 906 %}
postgresql-{{ pg.version.major }}-pgespresso:
    pkg.installed:
        - version: 1.2-3.pgdg14.04+1
        - require_in:
            - service: postgresql-service
{% endif %}

{% if salt['pillar.get']('data:diagnostic_tools', True) %}
{% if pg.version.major_num >= 1100 %}
postgresql-{{ pg.version.major }}-pg-stat-kcache:
{% else %}
postgresql-{{ pg.version.major }}-kcache:
{% endif %}
    pkg.installed:
        - version: {{ kcache_version }}
        - require_in:
            - service: postgresql-service
{% endif %}
