postgres-metrics-pkg:
    pkg.installed:
        - pkgs:
            - yamail-postgres-metrics: 0.2.38-5efb239
{% if salt['grains.get']('os') == 'Ubuntu' %}
            - python-daemon: 2.0.5-2yandex6
            - python-lockfile: 1:0.10.2-3yandex5
{% endif %}

/var/run/postgres-metrics:
    file.absent

/var/log/postgres-metrics:
    file.absent

/etc/postgres-metrics.conf.d/available:
    file.directory:
        - user: root
        - group: root
        - makedirs: True
        - mode: 755

/etc/postgres-metrics.conf.d/enabled:
    file.directory:
        - user: root
        - group: root
        - makedirs: True
        - mode: 755
        - require_in:
            - service: postgres-metrics-service

postgres-metrics-config:
    file.managed:
        - name: /etc/postgres-metrics.conf
        - template: jinja
        - source: salt://{{ slspath }}/conf/postgres-metrics.conf
        - defaults:
{% if salt['pillar.get']('yandex:environment', 'dev') == 'prod' %}
            environment: production
{% else %}
            environment: testing
{% endif %}

postgres-metrics-service:
    service:
        - running
        - enable: true
        - name: postgres-metrics
        - watch:
            - pkg: postgres-metrics-pkg
        - require:
            - service: postgresql-service
