{% from "components/postgres/pg.jinja" import pg with context %}
statbox-in-postgres-group:
    group.present:
        - name: postgres
        - addusers:
            - statbox
        - system: True
        - watch_in:
            - service: pushclient
        - require_in:
            - service: pushclient
        - require:
            - user: statbox-user

/etc/pushclient/pgbouncer_parser.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/pushclient/pgbouncer_parser.py
        - template: jinja
        - mode: 755
        - makedirs: True
        - watch_in:
            - service: pushclient
        - require:
            - pkg: pushclient

/etc/pushclient/postgres_csv_parser.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/pushclient/postgres_csv_parser.py
        - template: jinja
        - mode: 755
        - makedirs: True
        - watch_in:
            - service: pushclient
        - require:
            - pkg: pushclient

/etc/pushclient/pgsync_parser.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/pushclient/pgsync_parser.py
        - template: jinja
        - mode: 755
        - makedirs: True
        - watch_in:
            - service: pushclient
        - require:
            - pkg: pushclient

push-client-postgres-config:
    file.accumulated:
        - name: push-client-files
        - filename: /etc/yandex/statbox-push-client/push-client.yaml
        - text: |-
{% if pg.connection_pooler == 'pgbouncer' %}
{% if salt['pillar.get']('data:pgbouncer:count', 1) > 1 %}
{%   for count in range(salt['pillar.get']('data:pgbouncer:count', 1)) %}
{%     set num="%02d"|format(count|int) %}
                - topic: disk/ydisk-pgbouncer-log
                  name: /var/log/postgresql/pgbouncer{{num}}.log
                  pipe: /etc/pushclient/pgbouncer_parser.py -c {{ salt['pillar.get']('data:dbaas:cluster_id', salt['grains.get']('id').split('.')[0][:-3]) }} -o pgbouncer_ext
{%   endfor %}
{%   for count in range(salt['pillar.get']('data:pgbouncer:internal_count', 1)) %}
{%     set num="%02d"|format(count|int) %}
                - topic: disk/ydisk-pgbouncer-log
                  name: /var/log/postgresql/pgbouncer_internal{{num}}.log
                  pipe: /etc/pushclient/pgbouncer_parser.py -c {{ salt['pillar.get']('data:dbaas:cluster_id', salt['grains.get']('id').split('.')[0][:-3]) }} -o pgbouncer_int
{%   endfor -%}
{%- else %}
                - topic: disk/ydisk-pgbouncer-log
                  name: /var/log/postgresql/pgbouncer.log
                  pipe: /etc/pushclient/pgbouncer_parser.py -c {{ salt['pillar.get']('data:dbaas:cluster_id', salt['grains.get']('id').split('.')[0][:-3]) }} -o pgbouncer
{% endif %}
{% endif %}
{% if salt['pillar.get']('data:ship_pg_logs', False) %}
                - topic: disk/ydisk-postgresql-log
                  name: /var/log/postgresql/postgresql-{{pg.version.major}}-data.csv
                  pipe: /etc/pushclient/postgres_csv_parser.py -c {{ salt['pillar.get']('data:dbaas:cluster_id', salt['grains.get']('id').split('.')[0][:-3]) }}
{% endif %}
{% if salt['pillar.get']('data:use_pgsync', False) %}
                - topic: disk/ydisk-pgsync-log
                  name: /var/log/pgsync/pgsync.log
                  pipe: /etc/pushclient/pgsync_parser.py {{ salt['pillar.get']('data:dbaas:cluster_id', salt['grains.get']('id').split('.')[0][:-3]) }}
{% endif %}
        - require:
            - file: /etc/pushclient/pgbouncer_parser.py
{% if salt['pillar.get']('data:ship_pg_logs', False) %}
            - file: /etc/pushclient/postgres_csv_parser.py
{% endif %}
{% if salt['pillar.get']('data:use_pgsync', False) %}
            - file: /etc/pushclient/pgsync_parser.py
{% endif %}
        - require_in:
            - file: /etc/yandex/statbox-push-client/push-client.yaml
