{% from "components/postgres/pg.jinja" import pg with context %}
{% set osrelease = salt['grains.get']('osrelease') %}

pgrepack-pkg:
    pkg.installed:
{% if salt['grains.get']('os') == 'Ubuntu' %}
        - name: postgresql-{{ pg.version.major }}-repack
        - version: '1.4.4-1.pgdg{{ osrelease }}+1+yandex0'
{% else %}
        - name: pg_repack{{ pg.version.short }}
        - version: 1.4.0-1.rhel6
{% endif %}

/etc/cron.yandex/index_repack.py:
    file.absent

/etc/cron.yandex/repack.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/repack.py
        - mode: 755
        - require:
            - file: /etc/cron.yandex

/etc/cron.yandex/clear_after_repack.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/clear_after_repack.py
        - mode: 755
        - require:
            - file: /etc/cron.yandex

/etc/logrotate.d/pg_repack:
    file.managed:
        - source: salt://{{ slspath }}/conf/index_repack.logrotate

{% if salt['pillar.get']('data:do_index_repack', False) %}
/etc/pg_index_repack.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/index_repack.conf
        - mode: 640
        - group: postgres
        - user: postgres
        - template: jinja

/etc/cron.d/pg_index_repack:
    file.managed:
        - source: salt://{{ slspath }}/conf/index_repack.cron
        - template: jinja
        - watch_in:
            - service: pg-common-configs-crond-reload

/var/log/pg_index_repack.log:
    file.managed:
        - user: postgres
        - group: postgres
        - replace: False
        - mode: 640
{% endif %}

{% if salt['pillar.get']('data:do_clear_after_repack', False) %}
/var/log/pg_clear_after_repack.log:
    file.managed:
        - user: postgres
        - group: postgres
        - replace: False
        - mode: 640
{% endif %}

{% if salt['pillar.get']('data:do_table_repack', False) %}
/etc/pg_table_repack.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/index_repack.conf
        - template: jinja

/etc/cron.d/pg_table_repack:
    file.managed:
        - source: salt://{{ slspath }}/conf/table_repack.cron
        - watch_in:
            - service: pg-common-configs-crond-reload

/var/log/pg_table_repack.log:
    file.managed:
        - user: postgres
        - group: postgres
        - replace: False
        - mode: 640
{% endif %}
